# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nathan Seal nathan@nathanseal.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE


import Xlib
import Xlib.display
import Xlib.XK
import Xlib.X
import time

string_to_button = {
    'button1' : Xlib.X.Button1,
    'button2' : Xlib.X.Button2,
    'button3' : Xlib.X.Button3
}

class VirtualInputX11:
	display = None
	scerrn = None
	def __init__(self):
	    print "######### starting X11 driver  ############"
		self.display = Xlib.display.Display()
		self.screen = self.display.screen()
	def __del__(self):
		self.display.close()
	
	def string_to_keycode(self, string):
		keysym = Xlib.XK.string_to_keysym(string)
		keycode = self.display.keysym_to_keycode(keysym)
		return keycode
	
	def event(self, tipe, detail, x=0, y=0):
		Xlib.ext.xtest.fake_input(self.display, tipe, detail=detail, x=x, y=y)
		
		self.display.flush()
	
	def keyPress(self, keystring):
		keycode = self.string_to_keycode(keystring)
		self.event(Xlib.X.KeyPress, keycode)
	
	def keyRelease(self, keystring):
		keycode = self.string_to_keycode(keystring)
		self.event(Xlib.X.KeyRelease, keycode)
	
	def moveMouse(self, x, y):
		"""
			0,0 is top left
			100,100 is botom right
		"""
		pointer = self.screen.root.query_pointer()._data
		if x == None:  
		    abx =  pointer['root_x']
		else:
		    abx = self.screen.width_in_pixels * x / 100
		if y == None:
		    aby =  pointer['root_y']
		else:
		    aby = self.screen.height_in_pixels * y / 100
		self.event(Xlib.X.MotionNotify, Xlib.X.NotifyNormal, abx, aby)
	
	def moveMouseRel(self, x, y):
		pointer = self.screen.root.query_pointer()._data
		abx = pointer['root_x'] + x
		aby = pointer['root_y'] + y
		self.event(Xlib.X.MotionNotify, Xlib.X.NotifyNormal, abx, aby)
	
	def buttonPress(self, button):
		self.event(Xlib.X.ButtonPress, string_to_button[button])
		
	def buttonRelease(self, button):
		self.event(Xlib.X.ButtonRelease, string_to_button[button])
	
	def isValidButton(self, button):
	    return button in string_to_button
	
	def isValidKey(self, key):
	    return self.string_to_keycode(key) != 0
		

def sleep(t):
	print "sleeping"
	while t > 0:
		print t
		time.sleep(1)
		t -= 1
	print "done"
def error(one, two):
	print "!!!error!!!"
if __name__ == "__main__":
	vi = VirtualInputX11()
	
	print vi.string_to_keycode('p')
	print vi.string_to_keycode('a')
	print vi.string_to_keycode('fjdgnd')
	#for i in range(500):
	    #vi.moveMouseRel(1, 0)
	    #time.sleep(0.001)
	
	#sleep(3)
	#vi.buttonPress(BUTTON1)
	#sleep(3)
	#vi.buttonRelease(BUTTON1)
	
