# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nathan Seal nathan@nathanseal.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gettext
from gettext import gettext as _
gettext.textdomain('wiimap')

from gi.repository import Gtk # pylint: disable=E0611
import logging
logger = logging.getLogger('wiimap')

from wiimap_lib import Window
from wiimap.AboutWiimapDialog import AboutWiimapDialog
from wiimap.PreferencesWiimapDialog import PreferencesWiimapDialog
import EditdialogDialog

from wiimap_core import wiimap, validMappings

# See wiimap_lib.Window.py for more details about how this class bworks
class WiimapWindow(Window):
	__gtype_name__ = "WiimapWindow"
	mappingFile = None
	
	namemap =  [
		('a', 'BTN_A'),
		('b', 'BTN_B'),
		('up', 'BTN_UP'),
		('down', 'BTN_DOWN'),
		('left', 'BTN_LEFT'),
		('right', 'BTN_RIGHT'),
		('home', 'BTN_HOME'),
		('minus', 'BTN_MINUS'),
		('plus', 'BTN_PLUS'),
		('one', 'BTN_1'),
		('two', 'BTN_2'),
		('acc', 'acc'),
		('xac', 'xac'),
		('yac', 'yac'),
		('zac', 'zac'),
		('xax', 'xax'),
		('yax', 'yax'),
		('zax', 'zax'),
		('irx', 'irx'),
		('iry', 'iry')
		]
	
	def finish_initializing(self, builder): # pylint: disable=E1002
		"""Set up the main window"""
		super(WiimapWindow, self).finish_initializing(builder)

		self.AboutDialog = AboutWiimapDialog
		self.PreferencesDialog = PreferencesWiimapDialog
		self.ConnectWindow = None
		
		self.statusbar = self.builder.get_object("statusbar")
		self.toolbar = self.builder.get_object("toolbar")
		context = self.toolbar.get_style_context()
		context.add_class(Gtk.STYLE_CLASS_PRIMARY_TOOLBAR)
		
		self.mapper = wiimap.WiiMap()
		
		self.connect_signals()
		self.setInputTextFields()
		
	def connect_signals(self):
		for wm in [1, 2, 3, 4]:
			for name, froom in self.namemap:
				field = self.builder.get_object('wiimote_%d_%s' % (wm, name))
				if field != None:
					field.connect('changed', self.change_mapping, wm, froom)
				    editButton = self.builder.get_object('edit_wiimote_%d_%s' % (wm, name))
				    if editButton != None:
				        mapType = validMappings.wiimoteFromMappings[name]
				        editButton.connect('clicked', self.openEditDialog, field, mapType, name)
		
		#other ui signals
		connects = [
			('clicked', 'newMapping', self.new_mapping, ()),
			('clicked', 'openMapping', self.load_mapping, ()),
			('clicked', 'saveMapping', self.save_mapping, ()),
			('clicked', 'saveasMapping', self.save_mapping_as, ()),
			('activate', 'mnu_new', self.new_mapping, ()),
			('activate', 'mnu_open', self.load_mapping, ()),
			('activate', 'mnu_save', self.save_mapping, ()),
			('activate', 'mnu_save_as', self.save_mapping_as, ())
		]
		for signal, name, func, params in connects:
			widget = self.builder.get_object(name)
			if widget:
				widget.connect(signal, func, *params)
	
	def setInputTextFields(self):
		for wm in [1, 2, 3, 4]:
			for name, froom in self.namemap:
				field = self.builder.get_object('wiimote_%d_%s' % (wm, name))
				key = 'wiimote.' + str(wm) + '.' + froom
				if field != None:
					text = ''
					for f, part in self.mapper.mappings.getMapping(key):
						text += part['fullcode']
						for p in part['params']:
						    text += ' ' + p
						text += ';'
					field.set_text(text)
	
	def new_mapping(self, widjet):
	    self.mapper.newMapping()
	    self.mappingFile = None
	    self.setInputTextFields()
	    self.set_title('Wiimap')
	    print 'new mapping'
	    
	def load_mapping(self, widget=None):
		print "open mapping"
		buttons = (Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_OPEN, Gtk.ResponseType.OK)
		#buttons = None
		filePicker = Gtk.FileChooserDialog(title='Open Wiimap file', parent=self, buttons=buttons, action=Gtk.FileChooserAction.OPEN)
		filePicker.set_filter(self.get_file_filter())
		#filePicker.add_filter()
		if self.mappingFile != None:
		    filePicker.set_filename(self.mappingFile)
		else:
		    filePicker.set_current_folder('wiimap/example_mappings')
		response = filePicker.run()
		if response == Gtk.ResponseType.OK:
			fileName = filePicker.get_filename()
			self.mapper.setMappingsFromFile(fileName)
			self.setInputTextFields()
			self.mappingFile = fileName
			self.set_title('Wiimap - ' + fileName.split('/')[-1])
		filePicker.destroy()
	
	def save_mapping(self, widget=None):
		if self.mappingFile == None or self.mapper.nosave:
				self.save_mapping_as()
		else:
		    print "saveing to " + self.mappingFile
			self.mapper.saveMappingToFile(self.mappingFile)
	
	def save_mapping_as(self, widget=None):
		buttons = (Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_SAVE, Gtk.ResponseType.OK)
		filePicker = Gtk.FileChooserDialog(title='Save Wiimap file', parent=self, buttons=buttons, action=Gtk.FileChooserAction.SAVE)
		filePicker.set_filter(self.get_file_filter())
		if self.mappingFile != None:
		    filePicker.set_filename(self.mappingFile)
		else:
		    filePicker.set_current_folder('wiimap/example_mappings')
		response = filePicker.run()
        if response == Gtk.ResponseType.OK:
	        fileName = filePicker.get_filename()
	        
	        self.mapper.nosave = False
		    self.mappingFile = fileName
		    self.save_mapping()
		    self.set_title('Wiimap - ' + fileName.split('/')[-1])
		filePicker.destroy()
	
	def get_file_filter(self):
	    f = Gtk.FileFilter()
	    f.add_pattern('*.wmap')
	    return f
	
	def on_startStopButton_clicked(self, widget):
		if self.mapper.is_running():
			print "stopping"
			self.mapper.stop()
			widget.set_stock_id('gtk-media-play')
			self.statusbar.push(0, 'Stopped')
			#widget.set_label('Start Wiimap')
		else:
			print "starting"
			#self.ConnectDialog = ConnectDialog.ConnectDialog()
			#self.ConnectDialog.set_mapper(self.mapper)
			#self.ConnectDialog.show()
			self.mapper.start(callback=self.doneConnecting, messageHandler=self.conectDialogPushMessage)
			self.statusbar.push(0, 'Connecting... (press 1 + 2)')
			widget.set_stock_id('gtk-media-stop')
    def doneConnecting(self):
        self.statusbar.push(0, 'Running')
        #self.ConnectDialog.destroy()
	 
	def conectDialogPushMessage(self, message):
	    print message
	    self.statusbar.push(0, message)
		#statusLabel = self.builder.get_object('connectStatus')
		#if statusLabel != None:
		#	statusLabel.set_text(message)
    
    def openEditDialog(self, widget, field, mapType, name):
        editDialog = EditdialogDialog.EditdialogDialog()
        editDialog.setMapType(mapType)
        if name == 'acc':
            editDialog.setInRange(0, 100)
        elif name in ['xac', 'yac', 'zac']:
            editDialog.setInRange(-100, 100)
        elif name in ['xax', 'yax', 'zax']:
            editDialog.setInRange(0, 360)
        elif name in ['irx', 'iry']:
            editDialog.setInRange(0, 100)
        result = editDialog.run()
        print `result`
        if result == Gtk.ResponseType.OK:
            text = editDialog.get_text()
            field.set_text(text)
            print 'Text', text
        editDialog.destroy()
	
	def change_mapping(self, widget, wm, froom):
		string = widget.get_text()
		self.mapper.setMappingFromString('wiimote.' + str(wm) + '.' + froom, string)
		print 'mapping set'
	
	def on_destroy(self, widget, data=None):
	    self.mapper.stop()
	    super(WiimapWindow, self).on_destroy(self, widget)

