# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Nathan Seal nathan@nathanseal.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611

from wiimap_lib.helpers import get_builder

import gettext
from gettext import gettext as _
gettext.textdomain('wiimap')

from wiimap_core import grabKey

class EditdialogDialog(Gtk.Dialog):
    """
    meh, I stuffed the name up
    """
    __gtype_name__ = "EditdialogDialog"
    
    validOutTypes = []
    actions = []
    minInRange = 0
    maxInRange = 100
    
    def setInRange(self, mi, ma):
        self.minInRange = mi
        self.maxInRange = ma

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated EditdialogDialog object.
        """
        builder = get_builder('EditdialogDialog')
        new_object = builder.get_object('editdialog_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a EditdialogDialog object with it in order to
        finish initializing the start of the new EditdialogDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)
        self.toTypePicker = self.builder.get_object('toTypePicker')
        self.actions_vbox = self.builder.get_object('actions_vbox')
        
    def on_btn_ok_clicked(self, widget, data=None):
        """The user has elected to save the changes.

        Called before the dialog returns Gtk.ResponseType.OK from run().
        """
        pass

    def on_btn_cancel_clicked(self, widget, data=None):
        """The user has elected cancel changes.

        Called before the dialog returns Gtk.ResponseType.CANCEL for run()
        """
        pass
    def run(self, **kwargs):
        self.actions = []
        for t in self.validOutTypes:
            self.toTypePicker.append_text(t)
        self.toTypePicker.set_active(0)
        return super(EditdialogDialog, self).run(**kwargs)
        
    def on_btn_add_clicked(self, widget):
        value = self.toTypePicker.get_active_text()
        print value
        if value:
            inside = None
            if self.mapType == 'boolean':
                if value == 'Keyboard':
                    inside = BooleanKeyboard()
                elif value == 'Mouse Button':
                    inside = BooleanMouseButton()
            elif self.mapType == 'linear':
                if value == 'Keyboard':
                    inside = LinearKeyboard()
                elif value == 'Mouse Button':
                    inside = LinearMouseButton()
                elif value == 'Mouse X':
                    inside = LinearMouseX()
                elif value == 'Mouse Y':
                    inside = LinearMouseY()
                inside.setRange(self.minInRange, self.maxInRange)
            if inside:
                self.actions.append(inside)
                self.actions_vbox.pack_start(inside, False, False, 0)
                inside.show()
    
    def removeAction(self, action):
        self.actions.remove(action)
        self.actions_vbox.remove(action)
        
    def setMapType(self, mapType):
        print "##setMapType##"
        self.mapType = mapType
        if mapType == 'boolean':
            self.validOutTypes = ['Keyboard', 'Mouse Button']
        elif mapType == 'linear':
            self.validOutTypes = ['Keyboard', 'Mouse Button', 'Mouse X', 'Mouse Y']
        print "set maptype for dialog to", mapType
    def get_text(self):
        result = ''
        for action in self.actions:
            result += action.getMapString()
        return result
        
class actionPicker(Gtk.Frame):
    removed = False
    def __init__(self, startValue=''):
        """set up insides of widget"""
        super(actionPicker, self).__init__()
        self.vbox = Gtk.VBox()
        self.btn_remove = Gtk.Button()
        self.btn_remove.set_label('Remove')
        self.btn_remove.connect('clicked', self.remove)
        self.btn_remove_align = Gtk.Alignment()
        self.btn_remove_align.set(1, 0.5, 0, 0)
        self.btn_remove_align.add(self.btn_remove)
        self.btn_remove.xalign = 1
        self.btn_remove.xscale = 1
        self.vbox.pack_end(self.btn_remove_align, False, False, 0)
        self.add(self.vbox)
        if callable(self.setup):
            self.setup(startValue)
    
    def show(self):
        super(actionPicker, self).show()
        self.vbox.show()
        self.btn_remove.show()
        self.btn_remove_align.show()
    
    def set_onRemove(onRemove):
        self.onRemove = onRemove
    
    def remove(self, widget):
        self.removed = True
        self.destroy()
        if callable(self.onRemove):
            onRemove(self)
    
    def getMapString(self):
        """return to map string"""
        return ''

class BooleanKeyboard(actionPicker):
    def setup(self, startValue=''):
        self.entry = Gtk.Entry()
        self.entry.set_text(startValue)
        self.invert = Gtk.CheckButton('Invert')
        self.btn_capture = Gtk.Button()
        self.btn_capture.set_label('Capture')
        self.btn_capture.connect('clicked', self.capture)
        self.hbox = Gtk.HBox()
        self.hbox.pack_start(self.entry, False, False, 0)
        self.hbox.pack_end(self.btn_capture, False, False, 0)
        self.vbox.pack_start(self.hbox, False, False, 0)
        self.vbox.pack_start(self.invert, False, False, 0)
        
        self.set_label('Keyboard')
        
    def show(self):
        super(BooleanKeyboard, self).show()
        self.hbox.show()
        self.invert.show()
        self.entry.show()
        self.btn_capture.show()
    
    captureing = False
    def capture(self, widget):
        if not self.captureing:
            self.captureing = True
            key = grabKey.grabKey()
            self.entry.set_text(key)
            self.captureing = False
    
    def getMapString(self):
        result = ''
        entryText = self.entry.get_text()
        if entryText != '':
            invert = ''
            if self.invert.get_active():
                invert = ' invert'
            result = 'keyboard.' + entryText + invert + ';'
        return result

class BooleanMouseButton(actionPicker):
    def setup(self, startValue=''):
        self.buttonPicker = Gtk.ComboBoxText()
        self.buttonPicker.append_text('Left Button')
        self.buttonPicker.append_text('Right Button')
        self.buttonPicker.append_text('Middle Button')
        self.invert = Gtk.CheckButton('Invert')
        if startValue == 'button1':
            self.buttonPicker.set_active(0)
        elif startValue == 'button2':
            self.buttonPicker.set_active(3)
        elif startValue == 'button3':
            self.buttonPicker.set_active(2)
        self.vbox.pack_start(self.buttonPicker, False, False, 0)
        self.vbox.pack_start(self.invert, False, False, 0)
        
        self.set_label('Mouse Button')
        
    def show(self):
        super(BooleanMouseButton, self).show()
        self.buttonPicker.show()
        self.invert.show()
    
    def getMapString(self):
        result = ''
        entryText = self.buttonPicker.get_active_text()
        if entryText == 'Left Button':
            result = 'mouse.button1'
        elif entryText == 'Right Button':
            result = 'mouse.button3'
        elif entryText == 'Middle Button':
            result = 'mouse.button2'
        if result != '':
            invert = ''
            if self.invert.get_active():
                invert += ' invert'
            result += ';'
        return result

class LinearKeyboard(actionPicker):
    def setup(self, startValue=''):
        self.entry = Gtk.Entry()
        self.entry.set_text(startValue)
        self.btn_capture = Gtk.Button()
        self.btn_capture.set_label('Capture')
        self.btn_capture.connect('clicked', self.capture)
        self.scaleLow = Gtk.Scale()
        self.scaleLow.set_range(0, 100)
        self.scaleHigh = Gtk.Scale()
        self.scaleHigh.set_range(0, 100)
        self.hbox = Gtk.HBox()
        self.hbox.pack_start(self.entry, False, False, 0)
        self.hbox.pack_end(self.btn_capture, False, False, 0)
        self.vbox.pack_start(self.hbox, False, False, 0)
        self.vbox.pack_start(self.scaleLow, False, False, 0)
        self.vbox.pack_start(self.scaleHigh, False, False, 0)
        
        self.set_label('Keyboard')
        
    def show(self):
        super(LinearKeyboard, self).show()
        self.hbox.show()
        self.entry.show()
        self.btn_capture.show()
        self.scaleLow.show()
        self.scaleHigh.show()
    
    captureing = False
    def capture(self, widget):
        if not self.captureing:
            self.captureing = True
            key = grabKey.grabKey()
            self.entry.set_text(key)
            self.captureing = False
    
    def getMapString(self):
        result = ''
        entryText = self.entry.get_text()
        if entryText != '':
            result += 'keyboard.' + entryText
            result += ' ' + str(self.scaleLow.get_value())
            result += ' ' + str(self.scaleHigh.get_value())
            result += ';'
        return result
    def setRange(self, mi, ma):
        self.scaleLow.set_range(mi, ma)
        self.scaleHigh.set_range(mi, ma)
        
class LinearMouseButton(actionPicker):
    def setRange(self, mi, ma):
        self.scaleLow.set_range(mi, ma)
        self.scaleHigh.set_range(mi, ma)
    def setup(self, startValue=''):
        
        self.buttonPicker = Gtk.ComboBoxText()
        self.buttonPicker.append_text('Left Button')
        self.buttonPicker.append_text('Right Button')
        self.buttonPicker.append_text('Middle Button')
        if startValue == 'button1':
            self.buttonPicker.set_active(0)
        elif startValue == 'button2':
            self.buttonPicker.set_active(3)
        elif startValue == 'button3':
            self.buttonPicker.set_active(2)
        self.scaleLow = Gtk.Scale()
        self.scaleLow.set_range(0, 100)
        self.scaleHigh = Gtk.Scale()
        self.scaleHigh.set_range(0, 100)
        self.vbox.pack_start(self.buttonPicker, False, False, 0)
        self.vbox.pack_start(self.scaleLow, False, False, 0)
        self.vbox.pack_start(self.scaleHigh, False, False, 0)
        
        self.set_label('Mouse Button')
        
    def show(self):
        super(LinearMouseButton, self).show()
        self.scaleLow.show()
        self.scaleHigh.show()
        self.buttonPicker.show()
    
    def getMapString(self):
        result = ''
        entryText = self.buttonPicker.get_active_text()
        if entryText == 'Left Button':
            result = 'mouse.button1'
        elif entryText == 'Right Button':
            result = 'mouse.button3'
        elif entryText == 'Middle Button':
            result = 'mouse.button2'
        if result != '':
            result += ' ' + str(self.scaleLow.get_value())
            result += ' ' + str(self.scaleHigh.get_value())
            result += ';'
        return result
        
class LinearMouse(actionPicker):
    label = 'Mouse'
    startOfString = 'mouse.x'
    def setRange(self, mi, ma):
        self.scalefLow.set_range(mi, ma)
        self.scalefHigh.set_range(mi, ma)
    def setup(self, startValue=''):
        self.scalefLow = Gtk.Scale()
        self.scalefLow.set_range(0, 100)
        self.scalefHigh = Gtk.Scale()
        self.scalefHigh.set_range(0, 100)
        self.scaletLow = Gtk.Scale()
        self.scaletLow.set_range(0, 100)
        self.scaletHigh = Gtk.Scale()
        self.scaletHigh.set_range(0, 100)
        self.vbox.pack_start(self.scalefLow, False, False, 0)
        self.vbox.pack_start(self.scalefHigh, False, False, 0)
        self.vbox.pack_start(self.scaletLow, False, False, 0)
        self.vbox.pack_start(self.scaletHigh, False, False, 0)
        
        self.set_label(self.label)
        
    def show(self):
        super(LinearMouse, self).show()
        self.scalefLow.show()
        self.scalefHigh.show()
        self.scaletLow.show()
        self.scaletHigh.show()
    
    def getMapString(self):
        result = ''
        result += self.startOfString
        result += ' ' + str(self.scalefLow.get_value())
        result += ' ' + str(self.scalefHigh.get_value())
        result += ' ' + str(self.scaletLow.get_value())
        result += ' ' + str(self.scaletHigh.get_value())
        result += ';'
        return result
class LinearMouseX(LinearMouse):
    label = 'Mouse X'
    startOfString = 'mouse.x'
class LinearMouseY(LinearMouse):
    label = 'Mouse Y'
    startOfString = 'mouse.y'

if __name__ == "__main__":
    dialog = EditdialogDialog()
    dialog.show()
    Gtk.main()
