#    Copyright (c) 2012 Christopher Wayne <cwayne@ubuntu.com>
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.



import logging
import optparse
import subprocess
import re
import shlex

import locale
from locale import gettext as _
locale.textdomain('unity-lens-vm')

from singlet.lens import SingleScopeLens, IconViewCategory, ListViewCategory

from unity_lens_vm import unity_lens_vmconfig

class VmLens(SingleScopeLens):

    class Meta:
        name = 'vm'
        description = 'VM Lens'
        search_hint = 'Search VMs'
        icon = 'unity-lens-vm.png'
        search_on_blank=True

    vbox_category = IconViewCategory("VirtualBox VMs", 'virtualbox')

    def search(self, search, results):
        for vbox in self.vbox_query(search):
            print vbox
            print "file:///home/cwayne/VirtualBox\ VMs/%s/%s.vbox" % (vbox, vbox)
            results.append( vbox,
                            'virtualbox',
                            self.vbox_category,
                            "application/x-virtualbox-vbox",
                            vbox,
                            'VirtualBox VM',
                            vbox)
        pass
        
        
    def vbox_query(self, search):
        try:
            vboxlist = subprocess.check_output(['vboxmanage', 'list', 'vms']).splitlines()
            results = []
            for vbox in vboxlist:
                vbox = re.sub('\{.*\}', '', vbox)
                if search in vbox:
                    results.append(shlex.split(vbox)[0])
            return results
        except:
            print "Error Occurred"
            return []
            
    def handle_uri(self, scope, uri):
        subprocess.call(['vboxmanage', 'startvm', uri])
        return SingleScopeLens.hide_dash_response(self, uri='')
            
            
                
            
