import logging
import optparse
import subprocess
import urllib2
import re
import time
import os

import locale
from locale import gettext as _
locale.textdomain('unity-lens-pypi')

from singlet.lens import SingleScopeLens, IconViewCategory, ListViewCategory

from unity_lens_pypi import unity_lens_pypiconfig

class PypiLens(SingleScopeLens):

    class Meta:
        name = 'pypi'
        description = 'Pypi Lens'
        search_hint = 'Search Pypi'
        icon = '/opt/extras.ubuntu.com/unity-lens-pypi/unity-lens-pypi.png'
        search_on_blank = False

    available_category = IconViewCategory("Available Modules", 'python')
    installed_category = IconViewCategory("Installed Modules", 'python')
    response = None
   

    def available_query(self, search):
        try:
            results=[]
            b = time.time()
            if not self.response:
                self.response = urllib2.urlopen('http://g.pypi.python.org/simple/').readlines()
            a = time.time()
            c = a - b
            print "Getting the list took %f seconds" % c
            count = 0
            if len(search) == 1:
                print "One letter search"
                print "Only allowing 50 results.  otherwise it's too slow"
                for line in self.response:
                    if count < 50:
                        if re.match(search, re.sub('<[^<]+?>', '', line), re.IGNORECASE):
                            count += 1
                            result = re.sub('<[^<]+?>', '', line)
                            results.append(result)
                    else:
                        pass
            elif len(search) > 1:
                print "Only allowing 100 results.  To keep speed up"
                for line in self.response:
                    if count < 100:
                        if re.search(search, line, re.IGNORECASE):
                            count += 1
                            result = re.sub('<[^<]+?>', '', line)
                            results.append(result)
                    else:
                        pass
            d = time.time()
            e = d - a
            print "Took %f seconds to parse the data" % e
            return results
        except (IOError, KeyError, urllib2.URLError, urllib2.HTTPError):
            print "Can't search pypi"
            return []
        except UnicodeError:
            pass
            
    def installed_query(self, search):
        try:
            results=[]
            data = subprocess.check_output(['pip', 'freeze'],universal_newlines=True).splitlines()
            for line in data:
                result = line.split('==')[0]
                if re.search(search, result, re.IGNORECASE):
                    results.append(result)
            return results
        except:
            print "Search failed.  Is pip installed?"
            return []
  
               
                                   

    def search(self, search, results):
        for result in self.installed_query(search):
            results.append('http://pypi.python.org/pypi/%s' % result,
                             'python',
                             self.installed_category,
                             "text/html",
                             result,
                             'Python Module',
                             'http://pypi.python.org/pypi/%s' % result)
        for result in self.available_query(search):
            results.append('http://pypi.python.org/pypi/%s' % result,
                             'python',
                             self.available_category,
                             "text/html",
                             result,
                             'Python Module',
                             'http://pypi.python.org/pypi/%s' % result)
        pass
