import os.path
import logging
import urllib2

import tweepy
from gi.repository import GLib, GdkPixbuf # pylint: disable=E0611
from ubatar.plugins import BaseService

logger = logging.getLogger('ubatar')


class TwitterService(BaseService):
    """Service to set profile picture for Gravatar."""
    name = 'twitter'
    title = 'Twitter'
    use_auth = True
    icon = 'twitter.png'
    provides = ['get', 'set']

    consumer_key = 'H8TnkuEWQ4FCwuiuLcBNg'
    consumer_secret = '5jYSrD3j9pEuif79l1w9sHMGKSHHucApAqPCzbwE'

    def __init__(self, key='', secret=''):
        self.img_format = 'jpeg'
        self.img_name = '%s.%s' % (self.name, self.img_format)
        self.key = key
        self.secret = secret

        self.auth = tweepy.OAuthHandler(self.consumer_key, self.consumer_secret)
        if self.key and self.secret:
            self.auth.set_access_token(self.key, self.secret)
            self.api = tweepy.API(self.auth)

    def set_image(self, pixbuf):
        """Set image from a GdkPixbuf object."""
        image_path = os.path.join(GLib.get_tmp_dir(), self.img_name)
        pixbuf.savev(image_path, self.img_format, [], [])

        image_path = self._normalize_image(pixbuf)
        logger.debug('%s: updating image' % self.name)
        user = self.api.update_profile_image(image_path)

    def get_image(self):
        """Get profile picture from Twitter and return its path."""
        screen_name = self.api.me().screen_name
        image_url = 'http://api.twitter.com/1/users/profile_image?screen_name=%s&size=original' % screen_name
        image_path = os.path.join(GLib.get_tmp_dir(), self.img_name)
        image_data = urllib2.urlopen(image_url)
        with open(image_path, 'w') as f:
            f.write(image_data.read())
            return image_path

    def _normalize_image(self, pixbuf):
        """
        Normalize image used for Twitter's profile picture
        and return the path to a temporary file.
        """
        image_path = os.path.join(GLib.get_tmp_dir(), self.img_name)
        pixbuf.savev(image_path, self.img_format, [], [])
        return image_path
