# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pablo SEMINARIO <pabluk@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gio, Gtk, WebKit # pylint: disable=E0611

from ubatar.plugins.twitter import TwitterService
from ubatar_lib.helpers import get_builder
from ubatar_lib.keyring import SecretServiceKeyring

import gettext
from gettext import gettext as _
gettext.textdomain('ubatar')

class AuthTwitterDialog(Gtk.Dialog):
    __gtype_name__ = "AuthTwitterDialog"

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated AuthTwitterDialog object.
        """
        builder = get_builder('AuthTwitterDialog')
        new_object = builder.get_object('auth_twitter_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a AuthTwitterDialog object with it in order to
        finish initializing the start of the new AuthTwitterDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)

        self.service = TwitterService()
        auth_url = self.service.auth.get_authorization_url()
        webview = WebKit.WebView()
        webview.load_uri(auth_url)
        webview.connect('notify::load-status', self.on_load_status_change)
        content_box = self.get_content_area()
        scrolledwindow_browser = Gtk.ScrolledWindow()
        scrolledwindow_browser.set_min_content_width(800)
        scrolledwindow_browser.set_min_content_height(600)
        scrolledwindow_browser.add(webview)
        content_box.add(scrolledwindow_browser)
        content_box.show_all()

    def on_load_status_change(self, webview, load_status, data=None):
        if webview.get_load_status() == WebKit.LoadStatus.FINISHED:
            if webview.get_uri() == 'https://twitter.com/oauth/authorize':
                doc = webview.get_dom_document()
                tag_code = doc.get_elements_by_tag_name('code')
                if tag_code:
                    node_code = tag_code.item(0)
                    if node_code:
                        pin_code = node_code.get_inner_text()
                        access_token = self.service.auth.get_access_token(pin_code)
                        settings = Gio.Settings("net.launchpad.ubatar")
                        settings.set_string('twitter-login', access_token.key)
                        keyring = SecretServiceKeyring()
                        keyring.set_password('twitter', access_token.key, access_token.secret)
                        settings.set_boolean('twitter-authorized', True)
                        self.response(Gtk.ResponseType.OK)

    def on_btn_ok_clicked(self, widget, data=None):
        """The user has elected to save the changes.

        Called before the dialog returns Gtk.ResponseType.OK from run().
        """
        pass

    def on_btn_cancel_clicked(self, widget, data=None):
        """The user has elected cancel changes.

        Called before the dialog returns Gtk.ResponseType.CANCEL for run()
        """
        pass


if __name__ == "__main__":
    dialog = AuthTwitterDialog()
    dialog.show()
    Gtk.main()
