# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Marcos Costales https://launchpad.net/~costales
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from xml.dom import minidom
from random import randrange


class Sentences:
    def __init__(self):
        self.sentences = ''
        self.rows_number = 0
        self.row = 0
    
    def load_file(self, xml_file):
        try:
            xml_sentences = minidom.parse(xml_file)
        except Exception, e:
            return False
        
        if len(xml_sentences.getElementsByTagName("sentence")) > 0:
            self.sentences = xml_sentences.getElementsByTagName("sentence")
            self.rows_number = len(self.sentences)
            return True
        else:
            return False

    def set_sentence(self):
        self.row = randrange(self.rows_number)
    
    def get_current_lang(self):
        return 'English'
    
    def get_current_subject(self):
        return self.sentences[self.row].getAttribute('subject')
    
    def get_current_verb(self):
        return self.sentences[self.row].getAttribute('verb')
    
    def get_current_tense(self):
        return self.sentences[self.row].getAttribute('tense')
    
    def get_current_option(self):
        return self.sentences[self.row].getAttribute('option')
    
    def get_current_object(self):
        return self.sentences[self.row].getAttribute('object')
    
    def get_current_solution(self):
        return self.sentences[self.row].getAttribute('solution1')
    
    def check_is_ok(self, user_sentence):
        current_sentence = ' '.join(user_sentence.split()).lower().decode('utf8')
        solution1 = ' '.join(self.sentences[self.row].getAttribute('solution1').split()).lower().decode('utf8')
        solution2 = ' '.join(self.sentences[self.row].getAttribute('solution2').split()).lower().decode('utf8')
        solution3 = ' '.join(self.sentences[self.row].getAttribute('solution3').split()).lower().decode('utf8')
        
        if current_sentence == solution1 and solution1 != '':
            return True
        if current_sentence == solution2 and solution2 != '':
            return True
        if current_sentence == solution3 and solution3 != '':
            return True
        
        return False

    def check_is_partial(self, user_sentence):
        current_sentence = ' '.join(user_sentence.split()).lower().decode('utf8')
        solution1 = ' '.join(self.sentences[self.row].getAttribute('solution1').split()).lower().decode('utf8')
        solution2 = ' '.join(self.sentences[self.row].getAttribute('solution2').split()).lower().decode('utf8')
        solution3 = ' '.join(self.sentences[self.row].getAttribute('solution3').split()).lower().decode('utf8')
        
        if solution1.startswith(current_sentence):
            return True
        if solution2.startswith(current_sentence):
            return True
        if solution3.startswith(current_sentence):
            return True
        
        return False
