# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
##
# Project: ppasc - PPA Software Center
# Author: Marco Scarpetta <marcoscarpetta@mailoo.org>
# Copyright: 2012 Marco Scarpetta
# License: GPL-3
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
# more details.
#
# On Debian GNU/Linux systems, the full text of the GNU General Public License
# can be found in the file /usr/share/common-licenses/GPL-3.
##

from gi.repository import Gtk,Gdk
import cairo
import sys

import gettext
from gettext import gettext as _
gettext.textdomain('ppasc')

def destroy(widget, response):
   widget.hide()
   return True

def show(widget, window):
   window.show_all()
   
def show_help(widget):
   pass

def get_menu(app):
   about = Gtk.AboutDialog()
   about.set_title(_('About'))
   about.set_transient_for(app.window)
   about.set_position(Gtk.WindowPosition.CENTER_ON_PARENT)
   about.set_border_width(10)
   about.connect('delete-event', destroy)
   about.connect('close', destroy)
   about.connect('response', destroy)
   about.set_program_name('PPA Software Center')
   about.set_version('0.2.2')
   about.set_copyright('Copyright © 2012 Marco Scarpetta <marcoscarpetta@mailoo.org>')
   about.set_comments(_('Search and install packages from PPAs'))
   about.set_license_type(Gtk.License.GPL_3_0)
   about.set_website('https://launchpad.net/ppasc')
   about.set_authors(['Marco Scarpetta'])
   image = cairo.ImageSurface.create_from_png('/opt/extras.ubuntu.com/ppasc/share/ppasc/media/128.png')
   icona = Gdk.pixbuf_get_from_surface(image,0,0,128,128)
   about.set_logo(icona)
   
   menubar = Gtk.MenuBar()
   item = Gtk.MenuItem()
   menubar.append(item)
   item.set_label(_('File'))
   submenu = Gtk.Menu()
   item.set_submenu(submenu)
   menuitem = Gtk.MenuItem()
   menuitem.set_label(_('Quit'))
   menuitem.connect('activate', Gtk.main_quit)
   submenu.append(menuitem)
   item = Gtk.MenuItem()
   menubar.append(item)
   item.set_label(_('Help'))
   submenu = Gtk.Menu()
   item.set_submenu(submenu)
   menuitem = Gtk.MenuItem()
   menuitem.set_label(_('About'))
   menuitem.connect('activate', show, about)
   submenu.append(menuitem)
   
   return menubar
   
