#!/usr/bin/env python
# -*- coding: utf-8 -*-

### BEGIN LICENSE
# Copyright © 2012 Vsevolod Velichko <torkvema@gmail.com>
# Copyright © 2012 Carlos da Costa <c.costa@outlook.com>
# Copyright © 2012 Erik Christiansson <erik@christiansson.net>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from . import TrackingService
from datetime import date
from dateutil.parser import parse as parsedate
import re

class RussianpostRuService(TrackingService):
    name = 'RussianPost.ru'
    url = 'http://www.russianpost.ru/resp_engine.aspx?Path=rp/servise/en/home/postuslug/trackingpo'
    post = 'OP=&PATHCUR=rp/servise/en/home/postuslug/trackingpo&PATHFROM=&WHEREONOK=&ASP=&PARENTID=&FORUMID=&NEWSID=&DFROM=&DTO=&CA=&CDAY=%(day)02d&CMONTH=%(month)02d&CYEAR=%(year)04d&NAVCURPAGE=&SEARCHTEXT=&BarCode=%(number)s&searchsign=1&searchbarcode=Search'
    referer = url

    def __init__(self, number):
        TrackingService.__init__(self, number)
        curdate = date.today()
        self.additional_fields = {'day': curdate.day, 'month': curdate.month, 'year': curdate.year}

    def _parse_page(self, html):
        html = html.decode('utf-8', 'ignore')
        res = re.search(r'<h2>Result of operation:</h2>(.*)</tbody></table>', html)
        if res is None:
            return []
        html = res.group(1)
        res = re.search(r'<tbody>(.*)$', html)
        if res is None:
            return []
        html = res.group(1)

        result = []
        for res in re.findall(r'<tr align="center"><td>(.*?)</td><td>(.*?)</td><td>.*?</td><td>(.*?)</td><td>(.*?)</td>.*?</tr>', html):
            op = res[0].strip()
            if res[3].strip() != '':
                op = res[3].strip()
            result.append((op, parsedate(res[1]), res[2]))
        return result


