#!/usr/bin/env python
# -*- coding: utf-8 -*-

### BEGIN LICENSE
# Copyright © 2012 Vsevolod Velichko <torkvema@gmail.com>
# Copyright © 2012 Carlos da Costa <c.costa@outlook.com>
# Copyright © 2012 Erik Christiansson <erik@christiansson.net>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from . import TrackingService

import re
from dateutil.parser import parse as parsedate

class PostenSeService(TrackingService):
  """Swedish postal service"""

  name = 'Posten.se'
  url = 'http://www.posten.se/tracktrace/TrackConsignments_do.jsp?trackntraceAction=saveSearch&consignmentId=%(number)s&lang=GB'
  def _parse_page(self, html):
      html = html.decode('ISO-8859-1', 'ignore')
      res = re.search(r'<table\s+class="result".*?</th></tr>(.*?)</table>', html, re.DOTALL)
      if res is None:
          return []
      html = res.group(1)
      result = []
      for res in re.findall('<tr[^>]*>\s*<td[^>]*>(.*?)</td>\s*<td[^>]*>(.*?), (.*?)</td>\s*</tr>', html, re.DOTALL):
          opdate, location, action = (x.strip() for x in res)
          opdate = parsedate(opdate.replace('kl ', ''))
          action = re.sub('\s+', ' ', action)
          location = re.sub('\s+', ' ', location)
          result.append((action, opdate, location))
      return result
