#!/usr/bin/env python
# -*- coding: utf-8 -*-

### BEGIN LICENSE
# Copyright © 2012 Vsevolod Velichko <torkvema@gmail.com>
# Copyright © 2012 Carlos da Costa <c.costa@outlook.com>
# Copyright © 2012 Erik Christiansson <erik@christiansson.net>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from . import TrackingService

import re
import json
from dateutil.parser import parse as parsedate

class FedexComService(TrackingService):
    name = "Fedex"
    url = 'http://www.fedex.com/Tracking'
    post = 'clienttype=dotcom&track=y&ascend_header=1&cntry_code=us&cntry_code=ru&language=english&mi=n&tracknumbers=%(number)s&action=1&language=null&cntry_code=null&clienttype=null'

    def _parse_page(self, html):
        html = html.decode('utf-8', 'ignore')
        res = re.search(r'var detailInfoObject\s*=\s*(\{.+\})', html)
        if res is None:
            return []
        history = None
        try:
            js = json.loads(res.group(1))
            history = js['scans']
        except:
            return []
        results = []
        for op in history:
            opdate = parsedate('%s, %s' % (op['scanDate'], op['scanTime']))
            location = op['scanLocation'] if 'scanLocation' in op else ''
            operation = op['scanStatus']
            if 'scanComments' in op:
                operation += '. ' + op['scanComments']
            results.append((operation, opdate, location))
        return results
