#!/usr/bin/env python
# -*- coding: utf-8 -*-

### BEGIN LICENSE
# Copyright © 2012 Vsevolod Velichko <torkvema@gmail.com>
# Copyright © 2012 Carlos da Costa <c.costa@outlook.com>
# Copyright © 2012 Erik Christiansson <erik@christiansson.net>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from httplib import HTTPConnection, HTTPSConnection
from urlparse import urlparse
import Cookie
import socket
import logging

class TrackingService(object):
    url = None
    number = None
    post = None
    post_type = 'application/x-www-form-urlencoded'
    additional_fields = None
    referer = None
    cookie = None
    logger = logging.getLogger('parcel_tracker_lib')
    name = 'Unknown Service'

    def _parse_page(self, html):
        '''This method should parse an html string and return
        the list of tuples (operation, date, post_office)'''
        raise NotImplementedError

    def _fetch_url(self, url, data, headers):
        purl = urlparse(url)
        qpath = purl.path
        if qpath == '':
            qpath = '/'

        port = 80
        if purl.query:
            qpath += '?' + purl.query

        https = False
        if purl.scheme == 'https':
            port = 443
            https = True
        if purl.port is not None:
            port = purl.port

        conn = None
        try:
            if https == True:
                conn = HTTPSConnection(host=purl.hostname, port=port, timeout=10)
            else:
                conn = HTTPConnection(host=purl.hostname, port=port, timeout=10)
            headers.update({
                'Host': purl.hostname,
                'User-Agent': 'Mozilla/5.0 (compatible; ParcelTracker/1.0)',
                'Accept': 'text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8',
                'Accept-Language': 'en-us',
                'Connection': 'close'
                })
            #self.logger.debug(headers)
            #self.logger.debug(data)
            conn.request('POST' if data is not None else 'GET', qpath, data, headers)

            # Get the response
            response = conn.getresponse()
            statuscode, statusmessage = response.status, response.reason
            self.logger.debug("Response (status/message): %s, %s", statuscode, statusmessage)
            #self.logger.debug(response.getheaders())
            resp = response.read()
            if statuscode == 302:
                parts = response.getheader('Location').split('?', 1)
                return self._fetch_url(urlunparse((purl.scheme, purl.netloc, parts[0], '', parts[1] if len(parts) > 1 else None, '')), data, headers)
            if statuscode != 200:
                #self.logger.debug(resp)
                raise Exception("%s service returned non-200 response: %d" % (self.__class__.__name__, statuscode))
            try:
                cookie = self.cookie
                if cookie is None:
                    cookie = Cookie.SimpleCookie()
                cookie.load(response.getheader('Set-Cookie'))
                self.cookie = cookie
            except AttributeError:
                pass
            return resp
        except socket.gaierror, e:
             self.logger.error("Network error: %s" %e)
             raise
        finally:
            if conn is not None:
                conn.close()

    def _get_page(self):
        fields = {'number':self.number}
        if self.additional_fields is not None:
            fields.update(self.additional_fields)

        url = self.url % fields

        data = self.post % fields if self.post is not None else None

        headers = {}
        if self.cookie is not None:
            headers['Cookie'] = self.cookie
        if self.referer is not None:
            headers['Referer'] = self.referer
        if data is not None:
            headers['Content-Type'] = self.post_type
        return self._fetch_url(url, data, headers)

    def __init__(self, number):
        self.number = number

    def fetch(self):
        try:
            page = self._get_page()
            updates = self._parse_page(page)
            return updates
        except Exception, e:
            self.logger.exception(e)
            return []
