/*
 *      smsdb.h
 *      
 *      Copyright 2012 Alex <alex@linuxonly.ru>
 *      
 *      This program is free software: you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *      
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *      
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __SMSDB_H__
#define __SMSDB_H__

#include "dbus-api.h"

struct _smsdb {
	//GDBM_FILE db;
	gchar *filepath;
};

typedef struct _smsdb *smsdb_t;

smsdb_t gmm_smsdb_open(gchar *appname, gchar *deviceid);
gboolean gmm_smsdb_close(smsdb_t smsdb);
gboolean gmm_smsdb_add_sms(smsdb_t smsdb, sms_full_message_t sms);
GSList *gmm_smsdb_read_sms_list(smsdb_t smsdb);
void gmm_smsdb_free_sms_list(GSList *smslist);
sms_full_message_t gmm_smsdb_read_sms_message(smsdb_t smsdb, gulong idvalue);
gboolean gmm_smsdb_remove_sms_message(smsdb_t smsdb, gulong idvalue);

#endif /* __SMSDB_H__ */
