/*
 *      nm.h
 *      
 *      Copyright 2012 Alex <alex@linuxonly.ru>
 *      
 *      This program is free software: you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *      
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *      
 *      You should have received a copy of the GNU General Public License
 *      along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __NM_H__
#define __NM_H__

#include <glib.h>
#include <net/if.h>

struct _nm_data {
	GDBusConnection *connection;
	GDBusProxy *nmproxy;
	gchar interface[IFNAMSIZ];
	gboolean enabled;
	guint64 rxbytes;
	guint64 rxpackets;
	guint64 rxerrs;
	guint64 rxdrop;
	guint64 rxfifo;
	guint64 rxframe;
	guint64 rxcompressed;
	guint64 rxmulticast;
	guint64 txbytes;
	guint64 txpackets;
	guint64 txerrs;
	guint64 txdrop;
	guint64 txfifo;
	guint64 txcolls;
	guint64 txcarrier;
	guint64 txcompressed;
};

typedef struct _nm_data *nm_data_t;

gboolean nm_update_device_connection_info(nm_data_t data, guint devid);
gboolean nm_get_device_enabled(nm_data_t data);
gchar *nm_get_device_interface(nm_data_t data);
gboolean nm_get_device_traffic(nm_data_t data, guint64 *rxbytes, guint64 *txbytes);
void nm_close(nm_data_t data);
nm_data_t nm_open(void);

#endif /* __NM_H__ */
