# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Jobi Kea Carter keacarterdev@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

# This is your preferences dialog.
#
# Define your preferences in
# data/glib-2.0/schemas/net.launchpad.flashgen.gschema.xml
# See http://developer.gnome.org/gio/stable/GSettings.html for more info.

from gi.repository import Gio # pylint: disable=E0611

import gettext
from gettext import gettext as _
gettext.textdomain('flashgen')

import logging
logger = logging.getLogger('flashgen')

from flashgen_lib.PreferencesDialog import PreferencesDialog

class PreferencesFlashgenDialog(PreferencesDialog):
    __gtype_name__ = "PreferencesFlashgenDialog"

    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the preferences dialog"""
        super(PreferencesFlashgenDialog, self).finish_initializing(builder)

        # Bind each preference widget to gsettings
        settings = Gio.Settings("net.launchpad.flashgen")
        widget = self.builder.get_object('output_dir')
        settings.bind("outputdir", widget, "text", Gio.SettingsBindFlags.DEFAULT) #*1* commented out line 
        
        widget = self.builder.get_object('filename')
        settings.bind("filename", widget, "text", Gio.SettingsBindFlags.DEFAULT)
        
        widget = self.builder.get_object('prompt_commit_duplicates_radio') #all are true because bool if for widgit exists?
        settings.bind("commitprompt", widget, "active", Gio.SettingsBindFlags.DEFAULT)
        
        widget = self.builder.get_object('always_commit_duplicates_radio')
        settings.bind("commitalways", widget, "active", Gio.SettingsBindFlags.DEFAULT)
        
        widget = self.builder.get_object('never_commit_duplicates_radio')
        settings.bind("commitnever", widget, "active", Gio.SettingsBindFlags.DEFAULT)
	
        widget = self.builder.get_object('always_confirm_remove_radio')
        settings.bind("removeconfirmalways", widget, "active", Gio.SettingsBindFlags.DEFAULT)
	
        widget = self.builder.get_object('never_confirm_remove')
        settings.bind("removeconfirmnever", widget, "active", Gio.SettingsBindFlags.DEFAULT)
        
        widget = self.builder.get_object('on_generate_prompt')
        settings.bind("generatepromptalways", widget, "active", Gio.SettingsBindFlags.DEFAULT)
        
        widget = self.builder.get_object('on_generate_use_defaults')
        settings.bind("generateusedefaults", widget, "active", Gio.SettingsBindFlags.DEFAULT)
        
        widget = self.builder.get_object('default_output_csv')
        settings.bind("defaultoutputcsv", widget, "active", Gio.SettingsBindFlags.DEFAULT)
        
        widget = self.builder.get_object('default_output_tsv')
        settings.bind("defaultoutputtsv", widget, "active", Gio.SettingsBindFlags.DEFAULT)
        
        
        
        
        # Code for other initialization actions should be added here.




























