# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Pete Burgers <deltify81@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import os
import pickle
import logging
logger = logging.getLogger(__name__)

SETTINGS_PATH = os.path.expanduser(os.path.join("~", ".config", "deltify"))
if not os.path.exists(SETTINGS_PATH):
    os.mkdir(SETTINGS_PATH)

SETTINGS_FILE = os.path.join(SETTINGS_PATH, "settings.pickle")
SETTINGS_FILE_VERSION = 1

# @TODO: Now I've learned how to use GSettings, we can use that instead
class Settings():
    def __init__(self):
        self.browser = None
        self.browser_profile = None
        self.bookmark_root_folder = None

    def load(self):
        if not os.path.exists(SETTINGS_FILE):
            logger.warn("No settings file found.")
            self.save()
            return
        try:
            with open(SETTINGS_FILE, "rb") as settings_file:
                version = pickle.load(settings_file)
                if version != SETTINGS_FILE_VERSION:
                    raise ValueError("Unsupported settings file version: %d" % version)

                self.browser_profile = pickle.load(settings_file)
                self.browser = pickle.load(settings_file)
                self.bookmark_root_folder = pickle.load(settings_file)
        except EOFError:
            logger.warn("Incomplete settings file - continuing")
            return
        
    def save(self):
        with open(SETTINGS_FILE, "wb") as settings_file:
            pickle.dump(SETTINGS_FILE_VERSION, settings_file)
            pickle.dump(self.browser_profile, settings_file)
            pickle.dump(self.browser, settings_file)
            pickle.dump(self.bookmark_root_folder, settings_file)
