# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Zach Burnham thejambi@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

'''
' This is where everything happens. The GUI has the text area and the calendar. 
' When those widget events happen, the entry files are saved and loaded from here.
'''

import gettext
from gettext import gettext as _
gettext.textdomain('dayjournal')

from gi.repository import Gtk # pylint: disable=E0611
import logging
logger = logging.getLogger('dayjournal')

import os
import datetime

from dayjournal_lib import Window
from dayjournal.AboutDayjournalDialog import AboutDayjournalDialog

# See dayjournal_lib.Window.py for more details about how this class works
class DayjournalWindow(Window):
    __gtype_name__ = "DayjournalWindow"
    
    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the main window"""
        super(DayjournalWindow, self).finish_initializing(builder)

        self.AboutDialog = AboutDayjournalDialog

        # Code for other initialization actions should be added here.
        
        self.djDirPath = os.path.join(os.path.expanduser("~"), "DayJournal")
        today = datetime.date.today()
        self.monthDirPath = os.path.join(self.djDirPath, str(today.year), str(today.month))
        self.filePath = os.path.join(self.monthDirPath, str(today.day) + ".txt")
        #print self.filePath
        self.entryBuffer = builder.get_object("textbuffer1")
        cal = builder.get_object("calendar1")
        cal.select_month(today.month - 1, today.year)
        cal.select_day(today.day)
        
    def on_day_selected(self, cal):
        #print "Day Selected"
        year = cal.get_date()[0]
        month = cal.get_date()[1] + 1
        day = cal.get_date()[2]
        
        self.monthDirPath = os.path.join(self.djDirPath, str(year), str(month))
        self.filePath = os.path.join(self.monthDirPath, str(day) + ".txt")
        #print self.filePath
        
        try:
            self.entryFile = open(self.filePath, 'r')
            self.entryBuffer.set_text(self.entryFile.read())
            self.entryFile.close()
        except IOError:
            #print "No entry for that day yet, creating blank entry"
            self.entryBuffer.set_text("")
        
    def on_entry_edited(self, buffer):
        entryText = buffer.get_text(buffer.get_start_iter(), buffer.get_end_iter(), True)
        if (entryText.strip() != ""):
            #print "Entry edited"
            if not os.path.exists(self.monthDirPath):
                os.makedirs(self.monthDirPath)
                
            self.entryFile = open(self.filePath, 'w')
            self.entryFile.write(buffer.get_text(buffer.get_start_iter(), buffer.get_end_iter(), True))
            self.entryFile.close()
        else:
            try:
                os.remove(self.filePath)
                if not os.listdir(self.monthDirPath):
                    os.rmdir(self.monthDirPath)
            except OSError:
                #print "Cannot remove that entry file"
                pass
                
            
        
        
        
        
