# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Zach Burnham thejambi@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gettext
from gettext import gettext as _
gettext.textdomain('dayjournal')

import logging
logger = logging.getLogger('dayjournal')

from dayjournal_lib.AboutDialog import AboutDialog

# See dayjournal_lib.AboutDialog.py for more details about how this class works.
class AboutDayjournalDialog(AboutDialog):
    __gtype_name__ = "AboutDayjournalDialog"
    
    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the about dialog"""
        super(AboutDayjournalDialog, self).finish_initializing(builder)
        
        self.set_name("DayJournal")
        self.set_website("http://zburnham.co.cc/dayjournal")
        self.set_comments("DayJournal is like typing on paper. Visit the homepage to read more.")

        # Code for other initialization actions should be added here.

