from cuttlefish.actions import CuttleAction
from cuttlefish.events import DBusEvent
from cuttlefish.plugins import CuttlePlugin
from cuttlefish.params import SelectParam, FileParam

import dbus


class ScreensaverAction(CuttleAction):
	CATEGORY = "Screensaver"

	def __init__(self):
		CuttleAction.__init__(self)

	def _get_screensaver(self):
		bus = dbus.SessionBus()
		screensaverobj = bus.get_object('org.gnome.ScreenSaver', '/')
		return dbus.Interface(screensaverobj, 'org.gnome.ScreenSaver')


class TurnOnScreensaver(ScreensaverAction, CuttlePlugin):
	NAME = 'Lock screen'
	DESCP = 'Lock the screen and turn on the screensaver'

	def __init__(self):
		ScreensaverAction.__init__(self)
		CuttlePlugin.__init__(self)

	def execute(self):		
		self._get_screensaver().Lock()


class TurnOffScreensaver(ScreensaverAction, CuttlePlugin):
	NAME = 'Unlock screen'
	DESCP = 'Unlock the screen and turn off the screensaver'

	def __init__(self):
		ScreensaverAction.__init__(self)
		CuttlePlugin.__init__(self)

	def execute(self):		
		self._get_screensaver().SetActive(False)



class ScreensaverChanged(DBusEvent):
	CATEGORY = "Screensaver"

	def __init__(self, isActive):
		DBusEvent.__init__(self, self._on_active_changed, 'ActiveChanged', 'org.gnome.ScreenSaver', None)
		self._isActive = isActive

	def _on_active_changed(self, isActive):
		if isActive == self._isActive:
			self.trigger()
	

class ScreensaverActivated(ScreensaverChanged, CuttlePlugin):
	NAME = "Screen is locked"
	DESCP = "React when the screen is locked or screensaver starts"
		
	def __init__(self):
		ScreensaverChanged.__init__(self, True)
		CuttlePlugin.__init__(self)


class ScreensaverDeactivated(ScreensaverChanged, CuttlePlugin):
	NAME = "Screen is unlocked"
	DESCP = "React when the screen is unlocked or screensaver stops"
		
	def __init__(self):
		ScreensaverChanged.__init__(self, False)
		CuttlePlugin.__init__(self)