from cuttlefish.actions import CuttleAction
from cuttlefish.plugins import CuttlePlugin
from cuttlefish.params import SelectParam

import dbus

class ChangePidginStatus(CuttleAction, CuttlePlugin):
	NAME = 'Change pidgin status'
	DESCP = 'Activate a saved status of pidgin'
	CATEGORY = 'Pidgin'
	PARAMS = {
		'statusid' : -1
	}
	
	class Editor(CuttlePlugin.Editor):
		def begin(self):
			bus = dbus.SessionBus();
			pidgobj = bus.get_object('im.pidgin.purple.PurpleService', '/im/pidgin/purple/PurpleObject')
			pidgin = dbus.Interface(pidgobj, 'im.pidgin.purple.PurpleInterface')

			stats = {}
			for sid in pidgin.PurpleSavedstatusesGetAll():
				stats[sid] = pidgin.PurpleSavedstatusGetTitle(sid)

			return {'statusid' : SelectParam('Select Status', stats)}
	

	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)
			
	def execute(self):
		bus = dbus.SessionBus();
		pidgobj = bus.get_object('im.pidgin.purple.PurpleService', '/im/pidgin/purple/PurpleObject')
		pidgin = dbus.Interface(pidgobj, 'im.pidgin.purple.PurpleInterface')

		pidgin.PurpleSavedstatusActivate(self._params['statusid'])


