from cuttlefish.actions import CuttleAction
from cuttlefish.plugins import CuttlePlugin
from cuttlefish.params import IntParam, SelectParam, FileParam
from threading import Event
from gi.repository import Gio, Gtk

from subprocess import Popen, PIPE

class Wait(CuttleAction, CuttlePlugin):
	NAME = "Wait"
	DESCP = "Wait for a specific amount of time"
	CATEGORY = "Misc"
	PARAMS = {
		'time' : 10
	}

	class Editor(CuttlePlugin.Editor):
		def begin(self):
			return {'time': IntParam('Time to wait (in seconds)')}


	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)

	def execute(self):
		self._event = Event()
		self._event.wait(int(self._params['time']))
		
	def interrupt(self):
		self._event.set()



class ProxyMode(CuttleAction, CuttlePlugin):
	NAME = "Change proxy mode"
	DESCP = "Chagne proxy mode"
	CATEGORY = "Network"
	PARAMS = {
		'mode': 'none'
	}

	class Editor(CuttlePlugin.Editor):

		def begin(self):
			return {'mode': SelectParam('Proxy Mode', {
				'none': 'None',
				'manual': 'Manual Configuration',
				'auto': 'Automatic Configuration'
				}, str)}
			

	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)
		
	def execute(self):
		settings = Gio.Settings.new('org.gnome.system.proxy')
		settings.set_string('mode', self._params['mode'])

		

class DefaultPrinter(CuttleAction, CuttlePlugin):
	NAME = 'Change default printer'
	DESCP = 'Change the default printer'
	CATEGORY = 'Hardware'
	PARAMS = {
		'printer': ''
	}	
	
	class Editor(CuttlePlugin.Editor):
		def begin(self):
			p = Popen(['lpstat', '-a'], stdout=PIPE)
			out, err = p.communicate()
			printers = {}
			for printer in [x.split(' ', 1)[0] for x in out[:-1].split('\n')]:
				printers[printer] = printer

			return {'printer': SelectParam('Printer', printers, str)}
			
	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)

	def execute(self):
		Popen(['lpoptions', '-d', self._params['printer']], stdout=PIPE).communicate()

		

class BackgroundChanger(CuttleAction, CuttlePlugin):
	NAME = "Change desktop background"
	DESCP = "Change the background wallpaper of the desktop"
	CATEGORY = "Misc"
	PARAMS = {
		'file': '',
		'mode': 'streched'
	}

	class Editor(CuttlePlugin.Editor):
		ORDER = ['file', 'mode']
		def begin(self):
			f_img = Gtk.FileFilter()
			f_img.set_name("Images")
			f_img.add_mime_type("image/png")
			f_img.add_mime_type("image/jpeg")
			f_img.add_mime_type("image/gif")
			f_img.add_pattern("*.png")
			f_img.add_pattern("*.jpg")
			f_img.add_pattern("*.gif")
			f_img.add_pattern("*.tif")
			f_img.add_pattern("*.xpm")

			return {
			'file': FileParam('Image', [f_img]),
			'mode': SelectParam('Display Mode', {
				'wallpaper': 'Tile',
				'zoom': 'Zoom',
				'centered': 'Center',
				'scaled': 'Scale',
				'streched':	'Fill',
				'spanned': 'Span'
				}, str)}

		
	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)
				
	def execute(self):
		settings = Gio.Settings.new('org.gnome.desktop.background')
		settings.set_string('picture-options', self._params['mode'])
		settings.set_string('picture-uri', 'file://' + self._params['file'])
