from cuttlefish.plugins import CuttlePlugin
from cuttlefish.events import CuttleEvent
from cuttlefish.params import MultiSelectParam, TimeParam
from gi.repository import GObject
from datetime import datetime



class TimeEvent(CuttleEvent, CuttlePlugin):
	NAME = 'At time of day'
	DESCP = "React at a specific time of the day"
	CATEGORY = 'Date & Time'
	PARAMS =  {
		'time' : (15,30),
		'days' : [0,1,2,3,4,5,6]
	}
	
	class Editor(CuttlePlugin.Editor):
		ORDER = ['time', 'days']

		def begin(self):
			return {
				'time' : TimeParam('Time'),
				'days' : MultiSelectParam('Days', {
					0 : 'Monday',
					1 : 'Tuesday',
					2 : 'Wednesday',
					3 : 'Thursdays',
					4 : 'Friday',
					5 : 'Saturday',
					6 : 'Sunday'
					})
			}
		
	def __init__(self):
		CuttleEvent.__init__(self)
		CuttlePlugin.__init__(self)

	def setup(self):
		self._hid = GObject.timeout_add(60000, self._check)

	def teardown(self):
		GObject.source_remove(self._hid)

	def _check(self):
		now = datetime.now()
		if (now.hour, now.minute) == self._params['time'] and now.weekday() in self._params['days']:
			self.trigger()

		return True