from cuttlefish.actions import CuttleAction
from cuttlefish.plugins import CuttlePlugin, debug
from cuttlefish.params import IntParam

from gi.repository import Gtk
import subprocess
import os
import signal


class PACtrlAction(CuttleAction):
	CATEGORY = 'Audio'

	def __init__(self, paramCallback):
		CuttleAction.__init__(self)
		self._paramCallback = paramCallback

	def execute(self):
		argv = ['pactl']

		_env = os.environ.copy()
		_env['LC_ALL'] = 'C'
		p = subprocess.Popen(['pactl', 'stat'], stdout=subprocess.PIPE, env=_env)
		out, err = p.communicate()
		for key, value in [x.split(': ') for x in out[:-1].split('\n')]:
			if key == 'Default Sink':
				default_sink = value
				break

		idx = '0'
		p = subprocess.Popen(['pactl', 'list', 'short', 'sinks'], stdout=subprocess.PIPE, env=_env)
		out, err = p.communicate()
		for sink_info in [x.split('\t') for x in out[:-1].split('\n')]:
			if sink_info[1] == default_sink:
				idx = sink_info[0]
				break

	
		argv.extend(self._paramCallback(idx))
		subprocess.Popen(argv)


class SetVolume(PACtrlAction, CuttlePlugin):
	NAME = 'Change volume'
	DESCP = 'Change the global volume'
	PARAMS = {
			'volume': 50
	}

	class Editor(CuttlePlugin.Editor):
		def begin(self):
			return {
				'volume': IntParam('Volume (in %)', Gtk.Adjustment(0, 0, 100, 1, 0, 0))
			}
		
	def __init__(self):
		PACtrlAction.__init__(self, lambda idx : ['set-sink-volume', idx, str(int(self._params['volume'])) + '%'])
		CuttlePlugin.__init__(self)


class MuteVolume(PACtrlAction, CuttlePlugin):
	NAME = 'Mute volume'
	DESCP = 'Mute the global volume'
		
	def __init__(self):
		PACtrlAction.__init__(self, lambda idx : ['set-sink-mute', idx, '1'])
		CuttlePlugin.__init__(self)


class UnmuteVolume(PACtrlAction, CuttlePlugin):
	NAME = 'Unmute volume'
	DESCP = 'Unmute the global volume'
		
	def __init__(self):
		PACtrlAction.__init__(self, lambda idx : ['set-sink-mute', idx, '0'])
		CuttlePlugin.__init__(self)

