# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Alexander von Bremen-Kuehne <noneed4anick@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

"""Code to add AppIndicator."""

from gi.repository import Gtk # pylint: disable=E0611
from gi.repository import AppIndicator3 # pylint: disable=E0611

from cuttlefish_lib.helpers import get_media_file
from cuttlefish.reflexes import REFLEXES
from cuttlefish.engine import ENGINE

import gettext
from gettext import gettext as _
gettext.textdomain('cuttlefish')

class Indicator:
    def __init__(self, window):
        self._window = window
        window._indicator = self
        self.indicator = AppIndicator3.Indicator.new('cuttlefish', '', AppIndicator3.IndicatorCategory.APPLICATION_STATUS)
        self.indicator.set_status(AppIndicator3.IndicatorStatus.ACTIVE)

        icon_uri = get_media_file("tentacle_indicator.png")
        icon_path = icon_uri.replace("file:///", '')
        self.indicator.set_icon(icon_path)

        #Uncomment and choose an icon for attention state. 
        #self.indicator.set_attention_icon("ICON-NAME")
        
        self.menu = Gtk.Menu()

        # Add items to Menu and connect signals.
        
        #Adding preferences button 
        #window represents the main Window object of your app


        menuShow = Gtk.MenuItem("Open Configuration")
        menuShow.connect("activate", self.on_show_window_activate)
        self.menu.append(menuShow)

        self.menu.append(Gtk.SeparatorMenuItem())
        self.menu.show_all()

        self._reflexes = {}
        self._reflexSep = Gtk.SeparatorMenuItem()
        for b in REFLEXES.list():
           self._add_reflex(b)
        REFLEXES.connect('save', self.on_save)
        REFLEXES.connect('delete', self.on_delete)

        self.menu.append(self._reflexSep)

        self.quit = Gtk.MenuItem("Quit")
        self.quit.connect("activate",window.on_mnu_close_activate)
        self.quit.show()
        self.menu.append(self.quit)

        # Add more items here                           

        self.indicator.set_menu(self.menu)

    
    def on_show_window_activate(self, widget, data=None):
        self._window.present()

    def on_save(self, sender, reflex):
        if reflex.record_id in self._reflexes:
            self._update_reflex(reflex)
        else:
            self._add_reflex(reflex)
        
    def on_delete(self, sender, record_id):
        if record_id in self._reflexes:
            self._delete_reflex(record_id)
    
    def _add_reflex(self, reflex):
       item = Gtk.MenuItem(reflex['name'])
       item.connect("activate", ENGINE.execute, reflex.record_id)
       if reflex['listInIndicator']:
            item.show()
       self.menu.insert(item, 2)
       self._reflexes[reflex.record_id] = item
       self._reflexSep.show()
    
    def _update_reflex(self, reflex):
        item = self._reflexes[reflex.record_id]
        item.set_label(reflex['name'])
        item.set_visible(reflex['listInIndicator'])

        self._reflexSep.set_visible(any([item.get_visible() for rid, item in self._reflexes.items()]))
        
    def _delete_reflex(self, record_id):
        self._reflexes[record_id].destroy()
        del self._reflexes[record_id]        

        self._reflexSep.set_visible(any([item.get_visible() for rid, item in self._reflexes.items()]))
        

def new_application_indicator(window):
    ind = Indicator(window)
    return ind.indicator
