from gi.repository import Gtk
from cuttlefish.plugins import CuttlePlugin, MANAGER

class CuttleAction:
	NAME = "UNKOWN"
	DESCP = "No documnentation passed with this plugin."
	
	def __init__(self):
		self._params = self.get_default_params()
	
	@classmethod
	def get_name(clazz):
		return 'No name given'
		
	@classmethod
	def get_descp(clazz):
		return 'No description given'
	
	@classmethod
	def get_default_params(clazz):
		return {}
		
	@classmethod	
	def get_param_ui(clazz):
		return {}
		
	def get_params(self):
		return self._params
	
	def set_params(self, params):
		self._params.update(params)
		
	def execute(self):
		pass

	def interrupt(self):
		pass

	
class FallbackAction(CuttleAction, CuttlePlugin):
	def __init__(self):
		CuttleAction.__init__(self)
		CuttlePlugin.__init__(self)

class ActionManager:

	def get_liststore(self):
		store = Gtk.ListStore(str, str, str, str)
		for cname, action in MANAGER.list(CuttleAction):
			store.append([cname, action.NAME, action.DESCP, action.CATEGORY])
		store.set_sort_column_id(1, Gtk.SortType.ASCENDING)
		return store

	def get_categories(self):
		store = Gtk.ListStore(str)
		store.append(['All Categories'])
		for cat in set([action.CATEGORY for key, action in MANAGER.list(CuttleAction)]):
			store.append([cat])
		store.set_sort_column_id(0, Gtk.SortType.ASCENDING)
		return store

	def get_instance(self, record, idx):
		clazz = self.get_class(record['actions'][idx]['type'])
		instance = clazz()
		if record['actions'][idx]['params']:
			instance.set_params(record['actions'][idx]['params'])
		return instance

	def get_class(self, id):
		return MANAGER.get_class(CuttleAction, id, FallbackAction)

