# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Alexander von Bremen-Kuehne <noneed4anick@gmail.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

# This is your preferences dialog.
#
# Define your preferences in
# data/glib-2.0/schemas/net.launchpad.cuttlefish.gschema.xml
# See http://developer.gnome.org/gio/stable/GSettings.html for more info.

from gi.repository import Gio # pylint: disable=E0611

import gettext
from gettext import gettext as _
gettext.textdomain('cuttlefish')
from ConfigParser import RawConfigParser

import os.path
import logging
logger = logging.getLogger('cuttlefish')

from cuttlefish_lib.PreferencesDialog import PreferencesDialog

class Buffer():
	def __init__(self):
		self._buf = ""

	def write(self, data):
		self._buf +=  data[0].upper() + data[1:].replace(' = ', '=')

	def get(self):
		return self._buf


class PreferencesCuttlefishDialog(PreferencesDialog):
    __gtype_name__ = "PreferencesCuttlefishDialog"

    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the preferences dialog"""
        super(PreferencesCuttlefishDialog, self).finish_initializing(builder)

        # Bind each preference widget to gsettings
        self._settings = Gio.Settings("net.launchpad.cuttlefish")

        self._settings.connect("changed::notifications", self.on_notifications_changed)
        self.ui.togNotifications.connect('notify::active', self.on_togNotifications_toggle)
		self.ui.togNotifications.set_active(self._settings.get_boolean("notifications"))
        
		self._settings.connect("changed::logging", self.on_logging_changed)
        self.ui.togLogging.connect('notify::active', self.on_togLogging_toggle)
		self.ui.togLogging.set_active(self._settings.get_boolean("logging"))
        
        self._autostartFile = os.path.abspath(os.path.expanduser('~/.config/autostart/cuttlefish.desktop'))
        self._autostart = RawConfigParser()
      
        if os.path.isfile(self._autostartFile):
        	self._autostart.read(self._autostartFile)
        else:        	
	        self._autostart.add_section('Desktop Entry', )
			self._autostart.set('Desktop Entry', 'Type', 'Application')
			self._autostart.set('Desktop Entry', 'Exec', '/opt/extras.ubuntu.com/cuttlefish/bin/cuttlefish --hidden')
			self._autostart.set('Desktop Entry', 'Hidden', 'false')
			self._autostart.set('Desktop Entry', 'NoDisplay', 'false')
			self._autostart.set('Desktop Entry', 'X-GNOME-Autostart-enabled', 'false')
			self._autostart.set('Desktop Entry', 'Name', 'Cuttlefish')
			self._autostart.set('Desktop Entry', 'Categories', 'GNOME;Utility;')
			self._autostart.set('Desktop Entry', 'Icon', '/opt/extras.ubuntu.com/cuttlefish/share/cuttlefish/media/tentacle.svg')
			self._autostart.set('Desktop Entry', 'Comment', 'Cuttlefish Autostart Entry')
			
		self.ui.togAutostart.set_active(self._autostart.getboolean('Desktop Entry', 'X-GNOME-Autostart-enabled'))
		self.ui.togAutostart.connect('notify::active', self.on_togAutostart_toggle)

        # Code for other initialization actions should be added here.

    def on_notifications_changed(self, settings, key):
		self.ui.togNotifications.set_active(settings.get_boolean("notifications"))

	def on_togNotifications_toggle(self, widget, data=None):
		self._settings.set_boolean('notifications', widget.get_active())
		
    def on_logging_changed(self, settings, key):
		self.ui.togLogging.set_active(settings.get_boolean("logging"))

	def on_togLogging_toggle(self, widget, data=None):
		self._settings.set_boolean('logging', widget.get_active())


	def on_togAutostart_toggle(self, widget, data=None):
		if widget.get_active():
			self._autostart.set('Desktop Entry', 'X-GNOME-Autostart-enabled', 'true')
		else:	
			self._autostart.set('Desktop Entry', 'X-GNOME-Autostart-enabled', 'false')

		with open(self._autostartFile, "w+") as theBestFileInTheWorld:
			buf = Buffer()
			self._autostart.write(buf)
			theBestFileInTheWorld.write(buf.get())
