#!/usr/bin/python
# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 John Vrbanac <john.vrbanac (at) linux.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from cuckoo.CuckooConfig import CuckooConfig
from cuckoo.CuckooConfigData import CuckooConfigData

import sys
import time
import os.path
import unittest
sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))

class TestCuckooConfig(unittest.TestCase):
	_instance = None
	
    def setUp(self):
		self._instance = CuckooConfig()
	
	def test_write_and_read(self):
		tmpData = CuckooConfigData()
		last_used_alarmlist = "alarmlist.cfg"
		default_volume = 3.22
		default_ring = "alarm.ogg"
		
		tmpData.set_last_used_alarmlist(last_used_alarmlist)
		tmpData.set_default_volume(default_volume)
		tmpData.set_default_ring(default_ring)
		
		self._instance.set_data(tmpData)
		self._instance.write_general_section()
		
		# Clearing data
		self._instance.set_data(None)
		
		self._instance.read_general_section()
		
		rData = self._instance.get_data()
		self.assertEquals(last_used_alarmlist, rData.get_last_used_alarmlist())
		self.assertEquals(default_volume, rData.get_default_volume())
		self.assertEquals(default_ring, rData.get_default_ring())

if __name__ == '__main__':    
    unittest.main()
