# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 John Vrbanac <john.vrbanac (at) linux.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE
from gi.repository import Gdk, Gtk, Dbusmenu, Unity


class Launcher(object):
    def create_launcher(self, desktopfile_name, current_window):
        quicklist = Dbusmenu.Menuitem.new()
        launcher = Unity.LauncherEntry.get_for_desktop_id(desktopfile_name)

        hide_menuitem = Dbusmenu.Menuitem.new()
        hide_menuitem.property_set(Dbusmenu.MENUITEM_PROP_LABEL, "Hide")
        hide_menuitem.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
        hide_menuitem.connect("item_activated", current_window.on_mnu_show_activate)
        quicklist.child_append(hide_menuitem)

        separator_menuitem = Dbusmenu.Menuitem.new()
        separator_menuitem.property_set(Dbusmenu.MENUITEM_PROP_TYPE, Dbusmenu.CLIENT_TYPES_SEPARATOR)
        separator_menuitem.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
        quicklist.child_append(separator_menuitem)

        enable_menuitem = Dbusmenu.Menuitem.new()
        enable_menuitem.property_set(Dbusmenu.MENUITEM_PROP_LABEL, "Activate All Alarms")
        enable_menuitem.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
        enable_menuitem.connect("item_activated", current_window.on_activate_all_items)
        quicklist.child_append(enable_menuitem)

        disable_menuitem = Dbusmenu.Menuitem.new()
        disable_menuitem.property_set(Dbusmenu.MENUITEM_PROP_LABEL, "Deactivate All Alarms")
        disable_menuitem.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
        disable_menuitem.connect("item_activated", current_window.on_deactivate_all_items)
        quicklist.child_append(disable_menuitem)

        separator_menuitem = Dbusmenu.Menuitem.new()
        separator_menuitem.property_set(Dbusmenu.MENUITEM_PROP_TYPE, Dbusmenu.CLIENT_TYPES_SEPARATOR)
        separator_menuitem.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
        quicklist.child_append(separator_menuitem)

        import_menuitem = Dbusmenu.Menuitem.new()
        import_menuitem.property_set(Dbusmenu.MENUITEM_PROP_LABEL, "Import Alarm List")
        import_menuitem.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
        import_menuitem.connect("item_activated", current_window.on_open_alarm_list_item_activate)
        quicklist.child_append(import_menuitem)

        save_menuitem = Dbusmenu.Menuitem.new()
        save_menuitem.property_set(Dbusmenu.MENUITEM_PROP_LABEL, "Save Alarm List")
        save_menuitem.property_set_bool(Dbusmenu.MENUITEM_PROP_VISIBLE, True)
        save_menuitem.connect("item_activated", current_window.on_save_alarm_list_item_activate)
        quicklist.child_append(save_menuitem)

        launcher.set_property('quicklist', quicklist)
        return launcher

    def is_urgent(self, toggle):
        self.ppalauncher.set_property("urgent", toggle)
        self.releaselauncher.set_property("urgent", toggle)

    def set_count(self, value):
        if value > 0:
            self.ppalauncher.set_property("count", value)
            self.releaselauncher.set_property("count", value)

            self.ppalauncher.set_property("count_visible", True)
            self.releaselauncher.set_property("count_visible", True)
        else:
            self.ppalauncher.set_property("count_visible", False)
            self.releaselauncher.set_property("count_visible", False)

    def __init__(self, window):
        print ("Configuring Launcher...")
        self.window = window

        self.ppalauncher = self.create_launcher("cuckoo.desktop", window)
        self.releaselauncher = self.create_launcher("extras-cuckoo.desktop", window)
