# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 John Vrbanac <john.vrbanac (at) linux.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gio  # pylint: disable=E0611
from cuckoo.CuckooConfigData import CuckooConfigData

import locale
from locale import gettext as _
locale.textdomain('cuckoo')

import logging
logger = logging.getLogger('cuckoo')

from cuckoo_lib.PreferencesDialog import PreferencesDialog


class PreferencesCuckooDialog(PreferencesDialog):
    __gtype_name__ = "PreferencesCuckooDialog"
    __config_data = None

    def finish_initializing(self, builder):  # pylint: disable=E1002
        """Set up the preferences dialog"""
        super(PreferencesCuckooDialog, self).finish_initializing(builder)

        self.builder = builder
        self.audioadjustment = self.builder.get_object("audioadjustment")
        self.audiochooser = self.builder.get_object("audiochooser")
        self.minimisedswitch = self.builder.get_object("minimized_switch")

    def refresh_from_data(self):
        if not self.__config_data == None:
            default_vol = self.__config_data.get_default_volume()
            default_vol = (default_vol / 1.75) * 100
            self.audioadjustment.set_value(default_vol)
            self.audiochooser.set_uri(self.__config_data.get_default_ring())
            self.minimisedswitch.set_active(self.__config_data.get_start_minimized())

    def set_data(self, data):
        self.__config_data = data
        self.refresh_from_data()

    def get_data(self):
        self.__config_data.set_default_volume((self.audioadjustment.get_value() / 100 * 1.75))
        self.__config_data.set_default_ring(self.audiochooser.get_uri())
        self.__config_data.set_start_minimized(self.minimisedswitch.get_active())
        return self.__config_data

    def get_volume(self):
        return self.audioadjustment.get_value()

    def set_volume(self, value):
        self.audioadjustment.set_value(float(value))

    def get_filename(self):
        return self.audiochooser.get_uri()

    def set_filename(self, filename):
        self.audiochooser.set_uri(filename)
