# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 John Vrbanac <john.vrbanac (at) linux.com>
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk  # pylint: disable=E0611
from cuckoo_lib.helpers import get_builder
from cuckoo.CuckooAlarmData import CuckooAlarmData


class CuckooAlarmButton(Gtk.Box):
    _alarm_data = None
    __gtype_name__ = "CuckooAlarmButton"

    def __init__(self):
        Gtk.Box.__init__(self)
        builder = get_builder("AlarmWidget")
        self.builder = builder

        self._alarm_data = CuckooAlarmData()
        self._alarm_data.populate_defaults()

        self.layout = self.builder.get_object("alarm_layout")
        self.icon = self.builder.get_object("alarm_icon")
        self.time = self.builder.get_object("alarm_time")
        self.button = self.builder.get_object("alarm_select_button")
        self.activate_switch = self.builder.get_object("activate_switch")
        self.activate_switch.connect("notify::active", self.on_activate_switch_activate)

        self.refresh_from_data()

        self.add(self.layout)
        self.show_all()

    def get_time(self):
        return self.time.get_text()

    def set_time(self, time_str):
        self.time.set_text(time_str)

    def refresh_from_data(self):
        self.time.set_text(self._alarm_data.get_time())
        self.activate_switch.set_active(self._alarm_data.get_activated())

    def get_data(self):
        self._alarm_data.set_activated(self.activate_switch.get_active())
        return self._alarm_data

    def set_data(self, data):
        self._alarm_data = data
        self.refresh_from_data()

    def on_activate_switch_activate(self, widget, data):
        self.get_data()
