# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Jorge Alda jorgealda115@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE
import gobject 
import dbus.mainloop.glib as dbusml
import ubuntuone.platform.credentials as u1cred
import json
import ubuntuone.couch.auth as auth
import mimetypes
import urllib
from gi.repository import Gtk
from tempfile import *
class u1():
    def login(self):
        global _login_success
        _login_success = False

        dbusml.DBusGMainLoop(set_as_default=True)
        loop = gobject.MainLoop()
     
        def quit(result):
            global _login_success
            loop.quit()
            if result:
                _login_success = True
     
        cd = u1cred.CredentialsManagementTool()
        d = cd.login()
        d.addCallbacks(quit)
        loop.run()
        if not _login_success:
            msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't connect to Ubuntu One"))
            msg.show()
        else:
            msg = Gtk.MessageDialog(None, 0, 0, 0, _("Connected to Ubuntu One"))
            msg.show()

    def logout(self):     
        dbusml.DBusGMainLoop(set_as_default=True)
        loop = gobject.MainLoop()

        def quit(result):
            loop.quit()

        cd = u1cred.CredentialsManagementTool()
        d = cd.clear_credentials()
        d.addCallbacks(quit)
        loop.run()
        msg = Gtk.MessageDialog(None, 0, 0, 0, _("Disconnected to Ubuntu One"))
        msg.show()
      

    def create_volume(self, path):
        base = "https://one.ubuntu.com/api/file_storage/v1/volumes/~/"
        auth.request(base + urllib.quote(path), http_method="PUT")

    def upload(self, local, name):
        # Create remote path (which contains volume path)
        remote = "alg3py/" + name
        base = "https://one.ubuntu.com/api/file_storage/v1/~/"
        answer = auth.request(base + urllib.quote(remote),
                            http_method="PUT",
                            request_body='{"kind":"file"}')
        node = json.loads(answer[1])

        # Read info about local file
        data = bytearray(open(local, 'rb').read())
        size = len(data)
        content_type = mimetypes.guess_type(local)[0]
        content_type = content_type or 'application/octet-stream'
        headers = {"Content-Length": str(size),
                 "Content-Type": content_type}

        # Upload content of local file to content_path from original response
        base = "https://files.one.ubuntu.com"
        url = base + urllib.quote(node.get('content_path'), safe="/~")
        auth.request(url, http_method="PUT",
                   headers=headers, request_body=data)
        msg = Gtk.MessageDialog(None, 0, 0, 0, _("File uploaded to Ubuntu One"))
        msg.show()


    def get_children(self, path):
        import json
        import ubuntuone.couch.auth as auth
        import urllib

        # Request children metadata
        base = "https://one.ubuntu.com/api/file_storage/v1/~/"
        url = base + urllib.quote(path) + "?include_children=true"
        answer = auth.request(url)

        # Create file list out of json data
        filelist = []
        node = json.loads(answer[1])
        if node.get('has_children') == True:
            for child in node.get('children'):
              child_path = urllib.unquote(child.get('path')).lstrip('/')
              filelist += [child_path]
        return filelist

    def get(self, remote):

        # Request metadata
        base = "https://one.ubuntu.com/api/file_storage/v1/~/"
        answer = auth.request(base + urllib.quote(remote))
        node = json.loads(answer[1])

        # Request content
        base = "https://files.one.ubuntu.com"
        url = base + urllib.quote(node.get('content_path'), safe="/~")
        answer = auth.request(url)
        f = NamedTemporaryFile(mode='wb', delete=False)
        f.write(answer[1])
        return f.name
