# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Jorge Alda jorgealda115@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611
from time import sleep
from alg3py_lib.helpers import get_builder
from alg3py_lib import Window
import gettext
from gettext import gettext as _
gettext.textdomain('alg3py')

class SplashWindow(Gtk.Window):
    __gtype_name__ = "SplashWindow"

    def __new__(cls):
        """Special static method that's automatically called by Python when 
        constructing a new instance of this class.
        
        Returns a fully instantiated NewmatrixDialog object.
        """
        builder = get_builder('SplashWindow')
        new_object = builder.get_object('splash_window')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a NewmatrixDialog object with it in order to
        finish initializing the start of the new NewmatrixDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)
        #self.ui.splash_window.set_position(GTK_WIN_POS_CENTER)

    def run(self):
        self.ui.splash_window.show_all()
        while Gtk.events_pending():
            Gtk.main_iteration()
        sleep(1)
        

    def close(self):
        self.ui.splash_window.destroy()
