# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Jorge Alda jorgealda115@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

from gi.repository import Gtk # pylint: disable=E0611

from alg3py_lib.helpers import get_builder

import gettext
from gettext import gettext as _
gettext.textdomain('alg3py')
import quickly.widgets.dictionary_grid as DG

class SelectscalarDialog(Gtk.Dialog):
    __gtype_name__ = "SelectscalarDialog"

    def __new__(cls):
        """Special static method that's automatically called by Python when
        constructing a new instance of this class.

        Returns a fully instantiated SelectscalarDialog object.
        """
        builder = get_builder('SelectscalarDialog')
        new_object = builder.get_object('selectscalar_dialog')
        new_object.finish_initializing(builder)
        return new_object

    def finish_initializing(self, builder):
        """Called when we're finished initializing.

        finish_initalizing should be called after parsing the ui definition
        and creating a SelectscalarDialog object with it in order to
        finish initializing the start of the new SelectscalarDialog
        instance.
        """
        # Get a reference to the builder and set up the signals.
        self.builder = builder
        self.ui = builder.get_ui(self)

    def import_grid(self, dicts):
        self.grid = DG.DictionaryGrid(dictionaries=[], keys=['Name'])
        for k in dicts.rows:
            if k['Type'] == 'Scalar':
                self.grid.append_row(k)
        self.grid.editable = False
        self.grid.get_selection().set_mode(1)
        self.ui.box1.pack_start(self.grid, True, True, 0)
        self.grid.show()

    def on_btn_ok_clicked(self, widget, data=None):
        """The user has elected to save the changes.

        Called before the dialog returns Gtk.ResponseType.OK from run().
        """
        pass

    def on_btn_cancel_clicked(self, widget, data=None):
        """The user has elected cancel changes.

        Called before the dialog returns Gtk.ResponseType.CANCEL for run()
        """
        pass

    @property
    def number(self):
        if self.ui.rad_new.get_active():
            return complex(self.ui.entry_number.get_text())
        else:
            return self.grid.selected_rows[0]['Object']

if __name__ == "__main__":
    dialog = SelectscalarDialog()
    dialog.show()
    Gtk.main()
