# -*- Mode: Python; coding: utf-8; indent-tabs-mode: nil; tab-width: 4 -*-
### BEGIN LICENSE
# Copyright (C) 2012 Jorge Alda jorgealda115@gmail.com
# This program is free software: you can redistribute it and/or modify it 
# under the terms of the GNU General Public License version 3, as published 
# by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful, but 
# WITHOUT ANY WARRANTY; without even the implied warranties of 
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR 
# PURPOSE.  See the GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License along 
# with this program.  If not, see <http://www.gnu.org/licenses/>.
### END LICENSE

import gettext
from gettext import gettext as _
gettext.textdomain('alg3py')
import quickly.widgets.dictionary_grid as DG

from gi.repository import Gtk, GLib, Gdk, Unity # pylint: disable=E0611
import logging
logger = logging.getLogger('alg3py')
from subprocess import call
import os, urlparse

from alg3py_lib import Window
from alg3py.AboutAlg3pyDialog import AboutAlg3pyDialog
from alg3py.SettingsDialog import SettingsDialog

from alg3py.NewmatrixDialog import *
from alg3py.SelectobjectDialog import SelectobjectDialog
from alg3py.SelectscalarDialog import SelectscalarDialog
from alg3py.AboutpluginsDialog import AboutpluginsDialog
from alg3py.SplashWindow import SplashWindow
from alg3py.Matrix_GUI import *
from alg3py.plugins.manager import plugins_manager
from alg3py.u1 import u1


# See alg3py_lib.Window.py for more details about how this class works
class Alg3pyWindow(Window):
    __gtype_name__ = "Alg3pyWindow"

    def finish_initializing(self, builder): # pylint: disable=E1002
        """Set up the main window"""
        spl = SplashWindow()
        spl.run()
        #spl.ui.splash_dialog.show()
        print 'passed'
        super(Alg3pyWindow, self).finish_initializing(builder)

        self.AboutDialog = AboutAlg3pyDialog
        self.Has_Object = False
        self.Dict = []
        self.DictGr = DG.DictionaryGrid(dictionaries=self.Dict, keys=['Name', 'Type'] )
        self.DictGr.editable = False
        self.DictGr.get_selection().set_mode(1)
        self.DictGr.show()
        self.actives = 0
        select = self.DictGr.get_selection()
        select.connect("changed", self.on_DictGr_row_activate)
        self.idc = 0
        self.ui.box2.pack_end(self.DictGr, True, True, 0)
        self.launcher = Unity.LauncherEntry.get_for_desktop_id("alg3py.desktop")

        self.pm = plugins_manager()
        try:
            self.pm.load()
            self.pm.setup()
        except:
            msg = Gtk.MessageDialog(None, 0, 3, 0, _('Error while loading plugins'))
            msg.show()
        
            
        self.plc = 1
        self.current = {'Type':'None'}
        self.plugins_menu = []
        for plugin in self.pm.plugins:
            try:
                menu = Gtk.MenuItem.new_with_label(plugin.name)
                plugin.parent = self
                menu.connect("activate", plugin.code)
                self.ui.menu7.attach(menu, 0, 1, self.plc, self.plc+1)
                self.plugins_menu = self.plugins_menu + [menu]
                self.plc = self.plc + 1
                menu.show()
            except:
                pass
        if len(self.pm.plugins) == 0:
            self.ui.mnu_plugins.hide()
        self.ui.tool_un.hide()
        self.ui.tool_bin.hide()
        self.ui.tool_extr.hide()
        self.ui.recentchoosermenu1.connect('item-activated', self.on_recentchoosermenu1_item_activated)
        spl.close()

    def on_mnu_new_activate(self, widget, data=None):
        self.new_matrix()

    def on_tool_new_activate(self, widget, data=None):
        self.new_matrix()

    def on_tool_newm_clicked(self, widget, data=None):
        self.new_matrix()

    def add_Object(self, Obj):
        self.DictGr.append_row(Obj)
        if self.Has_Object == False:
            self.current = Obj
            if Obj['Type'] == 'Matrix':
                self.M_G = Mat_GUI(Obj['Object'])
                self.ui.StbType.set_text(_('Matrix'))
                self.ui.StbDim.set_text(str(Obj['Object'].rows) + ' x ' + str(Obj['Object'].columns))
            elif Obj['Type'] == 'Scalar':
                self.M_G = Scalar_GUI(Obj['Object'])
                self.ui.StbType.set_text(_('Scalar'))
                self.ui.StbDim.set_text('')
            elif Obj['Type'] == 'Vector':
                self.M_G = Vect_GUI(Obj['Object'])
            self.DictGr.get_selection().unselect_all()
            (model, it) = self.DictGr.get_selection().get_selected()
            self.DictGr.get_selection().select_iter(model.get_iter_first())
            for DGr in self.DictGr.rows:
                if DGr['id'] == self.idc:
                    self.current = DGr      
        self.actives = self.actives + 1
        self.idc = self.idc + 1
        self.Has_Object = True
        self.launcher.set_property("count", self.actives)
        self.launcher.set_property("count_visible", True)

    def new_matrix(self):
        nmd = NewmatrixDialog()
        resp = nmd.run()
        if resp == Gtk.ResponseType.OK:
            M = Matrix(int(nmd.rows), int(nmd.cols))
            d = _('New %i x %i matrix')% (nmd.rows, nmd.cols)
            Obj = {'Object':M, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
            self.add_Object(Obj)
        nmd.destroy()

    def on_mnu_open_activate(self, widget, data=None):
        self.open_file()

    def open_file(self):
        dialog = Gtk.FileChooserDialog(_("Open alg3py File..."), None, Gtk.FileChooserAction.OPEN,(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_OPEN, Gtk.ResponseType.OK))
        filter = Gtk.FileFilter()
        filter.set_name(_("Alg3bra files"))
        filter.add_pattern("*.alg3")
        dialog.add_filter(filter)
        response = dialog.run()
        if response == Gtk.ResponseType.OK:
            try:
                filename = dialog.get_filename()
                M = load_Mat(filename)
                if isinstance(M, Matrix):
                    d = _('Matrix opened from ') + filename
                    Obj = {'Object':M, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':filename, 'using':True, 'descr':d }
                elif isinstance(M, Vect):
                    d = _('Vector opened from ') + filename
                    Obj = {'Object':M, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':filename, 'using':True, 'descr':d }
                else:
                    d = _('Scalar opened from ') + filename
                    Obj = {'Object':M, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':filename, 'using':True, 'descr':d }
                self.add_Object(Obj)
            except:
                msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't open file. It may be damaged"))
                msg.show()
        dialog.destroy()

    def on_tool_open_clicked(self, widget, data=None):
        self.open_file()

    def on_mnu_save_activate(self, widget, data=None):
        self.save_file()

    def on_mnu_save_as_activate(self, widget, data=None):
        self.save_file_as()

    def save_file_as(self):
        if self.Has_Object == True:
            dialog = Gtk.FileChooserDialog(_("Save Matrix File as..."), None, Gtk.FileChooserAction.SAVE,(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_SAVE, Gtk.ResponseType.OK))
            filter = Gtk.FileFilter()
            filter.set_name(_("Alg3bra files"))
            filter.add_pattern("*.alg3")
            dialog.add_filter(filter)
            response = dialog.run()
            if response == Gtk.ResponseType.OK:
                    filename = dialog.get_filename()
                    ext = os.path.splitext(filename)
                    if ext[1] != '.alg3':
                        filename = filename + '.alg3'
                    M = self.M_G.read()
                    save(M, filename)
                    self.current['Path'] = filename
            dialog.destroy()

    def save_file(self):
        if self.Has_Object == True:
            if self.current['Path'] == '-':
                dialog = Gtk.FileChooserDialog(_("Save Matrix File as..."), None, Gtk.FileChooserAction.SAVE,(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_SAVE, Gtk.ResponseType.OK))
                filter = Gtk.FileFilter()
                filter.set_name(_("Alg3bra files"))
                filter.add_pattern("*.alg3")
                dialog.add_filter(filter)
                response = dialog.run()
                if response == Gtk.ResponseType.OK:
                        filename = dialog.get_filename()
                        ext = os.path.splitext(filename)
                        if ext[1] != '.alg3':
                            filename = filename + '.alg3'
                        M = self.M_G.read()
                        save(M, filename)
                        self.current['Path'] = filename
                dialog.destroy()
            else:
                save(self.M_G.read(), self.current['Path'])

    def on_tool_save_clicked(self, widget, data=None):
        self.save_file()

    def close_Matrix(self):
        if self.actives > 0:
            self.actives = self.actives -1
            self.M_G.table.destroy()
            (model, it) = self.DictGr.get_selection().get_selected()
            model.remove(it)
            self.current['using'] = False
            self.launcher.set_property("count", self.actives)
            self.launcher.set_property("count_visible", True)
            if self.actives > 0:
                self.DictGr.get_selection().select_iter(model.get_iter_first())
            else:
                self.ui.scrolled.get_child().destroy()
                self.Has_Object = False
                self.launcher.set_property("count_visible", False)
                self.ui.tool_un.hide()
                self.ui.tool_bin.hide()
                self.ui.tool_extr.hide()
                self.ui.StbType.set_text(_('None'))
                self.ui.StbDim.set_text('')

    def on_mnu_exp_tex_activate(self, widget, data=None):
        if self.Has_Object == True:
            dialog = Gtk.FileChooserDialog(_("Export Matrix File as..."), None, Gtk.FileChooserAction.SAVE,(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_SAVE, Gtk.ResponseType.OK))
            filter = Gtk.FileFilter()
            filter.set_name(_("TeX files"))
            filter.add_pattern("*.tex")
            dialog.add_filter(filter)
            response = dialog.run()
            if response == Gtk.ResponseType.OK:
                    filename = dialog.get_filename()
                    ext = os.path.splitext(filename)
                    if ext[1] != '.tex':
                        filename = filename + '.tex'
                    M = self.M_G.read()
                    export_tex(M, filename)
            dialog.destroy()

    def on_mnu_exp_mathml_activate(self, widget, data=None):
        if self.Has_Object == True:
            dialog = Gtk.FileChooserDialog(_("Export Matrix File as..."), None, Gtk.FileChooserAction.SAVE,(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_SAVE, Gtk.ResponseType.OK))
            filter = Gtk.FileFilter()
            filter.set_name(_("MathML files"))
            filter.add_pattern("*.xml")
            dialog.add_filter(filter)
            response = dialog.run()
            if response == Gtk.ResponseType.OK:
                    filename = dialog.get_filename()
                    ext = os.path.splitext(filename)
                    if ext[1] != '.xml':
                        filename = filename + '.xml'
                    M = self.M_G.read()
                    export_MathML(M, filename)
            dialog.destroy()

    def on_mnu_delete_activate(self, widget, data=None):
        self.close_Matrix()

    def on_mnu_copy_activate(self, widget, data=None):
        clip = Gtk.Clipboard.get(Gdk.SELECTION_CLIPBOARD)
        strObj = str(self.current['Object'])
        clip.set_text(strObj, len(strObj))
        clip.store()

    def on_mnu_paste_activate(self, widget, data=None):
        try:
            clip = Gtk.Clipboard.get(Gdk.SELECTION_CLIPBOARD)
            q = clip.wait_for_text()
            M = text2Matrix(q)
            Obj = {'Object':M, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':_('Matrix pasted from clipboard')}
            self.add_Object(Obj)
        except:
            msg = Gtk.MessageDialog(None, 0, 3, 0, _("Malformed Matrix-representing text"))
            #Imagen: 0->i 1->! 2->? 3->- 4->
            msg.show()

    def on_mnu_cut_activate(self, widget, data=None):
        clip = Gtk.Clipboard.get(Gdk.SELECTION_CLIPBOARD)
        strObj = str(self.current['Object'])
        clip.set_text(strObj, len(strObj))
        clip.store()
        self.close_Matrix()

    def on_DictGr_row_activate(self, widget, data=None):
        try:
            if self.current['using'] == True:
                M1 = self.M_G.read()
                self.current['Object'] = M1
            M = self.DictGr.selected_rows[0]['Object']
            if self.Has_Object == True:
                self.M_G.table.destroy()
            self.current = self.DictGr.selected_rows[0]
            self.change_visible(self.current['Type'])
            if self.current['Type'] == 'Matrix':
                self.M_G = Mat_GUI(M)
                self.ui.StbType.set_text(_('Matrix'))
                self.ui.StbDim.set_text(str(self.current['Object'].rows) + ' x ' + str(self.current['Object'].columns))
            elif self.current['Type'] == 'Scalar':
                self.M_G = Scalar_GUI(M)
                self.ui.StbType.set_text(_('Scalar'))
                self.ui.StbDim.set_text('')
            elif self.current['Type'] == 'Vector':
                self.M_G = Vect_GUI(M)
                self.ui.StbType.set_text(_('Vector'))
                self.ui.StbDim.set_text(str(M.dimension))
            t = self.M_G.table
            self.ui.scrolled.add_with_viewport(t)
            self.ui.scrolled.show()
            self.Has_Object = True
            self.ui.mnu_edit_mode.set_label(_("Edition mode"))
            self.ui.StbMode.set_text(_('Read-only mode'))
            t.show_all()
        except:
            pass

    def on_mnu_preferences_activate(self, widget, data=None):
        if self.Has_Object:
            prfd = SettingsDialog()
            prfd.set_entries(self.current['Name'], self.current['descr'])
            resp = prfd.run()
            if resp == Gtk.ResponseType.OK:
                self.current['Name'] = prfd.name
                self.current['descr'] = prfd.description
                model = self.DictGr.get_model()
                for row in iter(model):
                    row[0] = row[2]['Name']
                self.DictGr.set_model(model)
            prfd.destroy()

    def on_tool_add_activate(self, widget, data=None):
        if self.current['Type'] == 'Matrix':
            sel = SelectobjectDialog()
            sel.type_of_Object('Matrix', self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    Mat2 = sel.Object['Object']
                    res = Mat2 + self.current['Object']
                    d = self.current['Name'] + ' + ' + sel.Object['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't sum matrices"))
                    msg.show()
            sel.destroy()
        elif self.current['Type'] == 'Scalar':
            sel = SelectscalarDialog()
            sel.import_grid(self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    n = sel.number
                    res = self.current['Object'] + n
                    d = str(n) + ' + ' + self.current['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Number not valid"))
                    msg.show()
            sel.destroy()
        elif self.current['Type'] == 'Vector':
            sel = SelectobjectDialog()
            sel.type_of_Object('Vector', self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    Mat2 = sel.Object['Object']
                    res = Mat2 + self.current['Object']
                    d = self.current['Name'] + ' + ' + sel.Object['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't sum vectors"))
                    msg.show()
            sel.destroy()

    def on_tool_substract_activate(self, widget, data=None):
        if self.current['Type'] == 'Matrix':
            sel = SelectobjectDialog()
            sel.type_of_Object('Matrix', self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    Mat2 = sel.Object['Object']
                    res = self.current['Object'] - Mat2
                    d = self.current['Name'] + ' - ' + sel.Object['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't substract matrices"))
                    msg.show()
            sel.destroy()
        elif self.current['Type'] == 'Scalar':
            sel = SelectscalarDialog()
            sel.import_grid(self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    n = sel.number
                    res = self.current['Object'] - n
                    d = str(n) + ' · ' + self.current['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Number not valid"))
                    msg.show()
            sel.destroy()
        elif self.current['Type'] == 'Vector':
            sel = SelectobjectDialog()
            sel.type_of_Object('Vector', self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    Mat2 = sel.Object['Object']
                    res = self.current['Object'] - Mat2
                    d = self.current['Name'] + ' - ' + sel.Object['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't substract vectors"))
                    msg.show()
            sel.destroy()

    def matr_pr(self):
        if self.current['Type'] == 'Matrix':
            sel = SelectobjectDialog()
            sel.type_of_Object('Matrix', self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    Mat2 = sel.Object['Object']
                    res = self.current['Object'] * Mat2
                    d = self.current['Name'] + ' · ' + sel.Object['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't multiply matrices"))
                    msg.show()
            sel.destroy()
        elif self.current['Type'] == 'Vector':
            sel = SelectobjectDialog()
            sel.type_of_Object('Matrix', self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    Mat2 = sel.Object['Object']
                    res = Mat2 * self.current['Object']
                    d = sel.Object['Name'] + ' · ' + self.current['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't multiply matrix and vector"))
                    msg.show()
            sel.destroy()


    def on_tool_mpr_activate(self, widget, data=None):
        self.matr_pr()

    def on_tool_scpr_activate(self, widget, data=None):
        if self.current['Type'] == 'Matrix':
            sel = SelectscalarDialog()
            sel.import_grid(self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    n = sel.number
                    res = self.current['Object'] * n
                    res.simplify()
                    d = str(n) + ' · ' + self.current['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Number not valid"))
                    msg.show()
            sel.destroy()
        elif self.current['Type'] == 'Scalar':
            sel = SelectscalarDialog()
            sel.import_grid(self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    n = sel.number
                    res = self.current['Object'] * n
                    d = str(n) + ' · ' + self.current['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Number not valid"))
                    msg.show()
            sel.destroy()
        elif self.current['Type'] == 'Vector':
            sel = SelectscalarDialog()
            sel.import_grid(self.DictGr)
            resp = sel.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    n = sel.number
                    res = self.current['Object'] * n
                    d = str(n) + ' · ' + self.current['Name']
                    Obj = {'Object':res, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("Number not valid"))
                    msg.show()
            sel.destroy()

    def on_tool_trans_activate(self, widget, data=None):
        M1 = self.M_G.read()
        M2 = M1.transpose()
        d = _('Transpose of matrix ') + self.current['Name']
        Obj = {'Object':M2, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
        self.add_Object(Obj)

    def on_tool_adjoint_activate(self, widget, data=None):
        if self.current['Type'] == 'Matrix':
            M1 = self.M_G.read()
            M2 = M1.adjoint()
            d = _('Adjoint of matrix ') + self.current['Name']
            Obj = {'Object':M2, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
            self.add_Object(Obj)
        elif self.current['Type'] == 'Scalar':
            M1 = self.M_G.read()
            M2 = M1.conjugate()
            d = _('Conjugate of ') + self.current['Name']
            Obj = {'Object':M2, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
            self.add_Object(Obj)

    def on_tool_inverse_activate(self, widget, data=None):
        M1 = self.M_G.read()
        if self.current['Type'] == 'Matrix':
            try:
                M2 = M1.inverse()
                d = _('Inverse of matrix ') + self.current['Name']
                Obj = {'Object':M2, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
                self.add_Object(Obj)
            except:
                msg = Gtk.MessageDialog(None, 0, 3, 0, _("Singular matrix!"))
                msg.show()
        elif self.current['Type'] == 'Scalar':
            try:
                res = 1.0 / M1
                d = _('Inverse of') + self.current['Name']
                Obj = {'Object':res, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
                self.add_Object(Obj)
            except:
                msg = Gtk.MessageDialog(None, 0, 3, 0, _("Division by 0!"))
                msg.show()

    def on_tool_adjugate_activate(self, widget, data=None):
        M1 = self.M_G.read()
        M2 = M1.adjugate()
        d = _('Adjugate of matrix ') + self.current['Name']
        Obj = {'Object':M2, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
        self.add_Object(Obj)

    def on_tool_det_activate(self, widget, data=None):
        M1 = self.M_G.read()
        det = M1.determinant()
        d = _('Determinant of matrix') + self.current['Name']
        Obj = {'Object':det, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
        self.add_Object(Obj)

    def on_tool_trace_activate(self, widget, data=None):
        M1 = self.M_G.read()
        tr = M1.trace()
        d = _('Trace of matrix') + self.current['Name']
        Obj = {'Object':tr, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
        self.add_Object(Obj)

    def on_tool_newsc_activate(self, widget, data=None):
        z = 0
        d = _('New scalar')
        Obj = {'Object':z, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
        self.add_Object(Obj)

    def on_tool_tpr_activate(self, widget, data=None):
        sel = SelectobjectDialog()
        sel.type_of_Object('Matrix', self.DictGr)
        resp = sel.run()
        if resp == Gtk.ResponseType.OK:
            Mat2 = sel.Object['Object']
            res = self.current['Object'] % Mat2
            d = self.current['Name'] + ' % ' + sel.Object['Name']
            Obj = {'Object':res, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
            self.add_Object(Obj)
        sel.destroy()

    def change_visible(self, t):
        if t == 'Matrix':
            self.ui.tool_trace.show()
            self.ui.tool_det.show()
            self.ui.tool_adjugate.show()
            self.ui.tool_trans.show()
            self.ui.tool_mpr.show()
            self.ui.tool_tpr.show()
            self.ui.tool_bin.show()
            self.ui.tool_un.show()
            self.ui.tool_dotpr.hide()
            self.ui.tool_crpr.hide()
            self.ui.tool_extr.show()
            self.ui.tool_ext_row.show()
            self.ui.tool_ext_col.show()
            self.ui.tool_ext_el.show()
            self.ui.tool_ext_subm.hide()#show()
            self.ui.tool_conv_row.hide()
            self.ui.tool_conv_col.hide()
            self.ui.tool_conv_mat.hide()
            self.ui.tool_conv_vect.hide()
        elif t == 'Scalar':
            self.ui.tool_trace.hide()
            self.ui.tool_det.hide()
            self.ui.tool_adjugate.hide()
            self.ui.tool_trans.hide()
            self.ui.tool_mpr.hide()
            self.ui.tool_tpr.hide()
            self.ui.tool_bin.show()
            self.ui.tool_un.show()
            self.ui.tool_dotpr.hide()
            self.ui.tool_crpr.hide()
            self.ui.tool_extr.show()
            self.ui.tool_ext_row.hide()
            self.ui.tool_ext_col.hide()
            self.ui.tool_ext_el.hide()
            self.ui.tool_ext_subm.hide()
            self.ui.tool_conv_row.hide()
            self.ui.tool_conv_col.hide()
            self.ui.tool_conv_mat.show()
            self.ui.tool_conv_vect.show()
        elif t == 'Vector':
            self.ui.tool_mpr.show()
            self.ui.tool_tpr.hide()
            self.ui.tool_bin.show()
            self.ui.tool_un.hide()
            self.ui.tool_dotpr.show()
            self.ui.tool_crpr.show()
            self.ui.tool_extr.show()
            self.ui.tool_ext_row.hide()
            self.ui.tool_ext_col.hide()
            self.ui.tool_ext_el.show()
            self.ui.tool_ext_subm.hide()
            self.ui.tool_conv_row.show()
            self.ui.tool_conv_col.show()
            self.ui.tool_conv_mat.hide()
            self.ui.tool_conv_vect.hide()

    def on_mnu_plugins_activate(self, widget, data=None):
        ap = AboutpluginsDialog()
        ap.load_plugins_list(self.pm.plugins)
        ap.run()
        ap.destroy()

    def on_mnu_add_plugin_activate(self, widget, data=None):
        dialog = Gtk.FileChooserDialog(_("Open alg3py plugin..."), None, Gtk.FileChooserAction.OPEN,(Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_OPEN, Gtk.ResponseType.OK))
        filter = Gtk.FileFilter()
        filter.set_name(_("Alg3bra plugin"))
        filter.add_pattern("*.py")
        dialog.add_filter(filter)
        response = dialog.run()
        if response == Gtk.ResponseType.OK:
            try:
                order = "gksu cp " + dialog.get_filename() + ' ' + self.pm.get_directory()
                call(order, shell=True)
                msg = Gtk.MessageDialog(None, 0, 0, 0, _("This plugin will be ready to use when you restart Alg3py"))
                msg.show()
            except:
                msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't open file. It may be damaged"))
                msg.show()
        dialog.destroy()
        

    def on_mnu_edit_mode_activate(self, widget, data=None):
        if (self.current['Type'] == 'Matrix') or (self.current['Type'] == 'Scalar') or (self.current['Type'] == 'Vector'):
            self.M_G.switch_mode()
            t = self.M_G.table
            self.ui.scrolled.add_with_viewport(t)
            self.ui.scrolled.show()
            if self.M_G.mode == 'Read-only':
                text = _("Edition mode")
                text2 = _("Read-only mode")
            else:
                text = _("Read-only mode")
                text2 = _("Edition mode")
            self.ui.mnu_edit_mode.set_label(text)
            self.ui.StbMode.set_text(text2)
            t.show_all()

    def on_tool_newv_activate(self, widget, data=None):
        nmd = NewmatrixDialog()
        nmd.modify_dialog(_('Dimension: '))
        resp= nmd.run()
        if resp == Gtk.ResponseType.OK:
            M = Vect(int(nmd.rows))
            d = _('New  %i vector')% nmd.rows
            Obj = {'Object':M, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d}
            self.add_Object(Obj)
        nmd.destroy()

    def on_tool_dotpr_activate(self, widget, data=None):
        sel = SelectobjectDialog()
        sel.type_of_Object('Vector', self.DictGr)
        resp = sel.run()
        if resp == Gtk.ResponseType.OK:
            try:
                w = sel.Object['Object']
                res = self.current['Object'] * w
                d = sel.Object['Name'] + ' · ' + self.current['Name']
                Obj = {'Object':res, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
                self.add_Object(Obj)
            except:
                msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't multiply vectors"))
                msg.show()

    def on_tool_crpr_activate(self, widget, data=None):
        sel = SelectobjectDialog()
        sel.type_of_Object('Vector', self.DictGr)
        resp = sel.run()
        if resp == Gtk.ResponseType.OK:
            try:
                w = sel.Object['Object']
                res = self.current['Object'] ^ w
                d = sel.Object['Name'] + ' ^ ' + self.current['Name']
                Obj = {'Object':res, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d}
                self.add_Object(Obj)
            except:
                msg = Gtk.MessageDialog(None, 0, 3, 0, _("Couldn't multiply vectors"))
                msg.show()
        sel.destroy()

    def on_tool_ext_row_activate(self, widget, data=None):
        nmd = NewmatrixDialog()
        nmd.modify_dialog(_('Row: '))
        nmd.ui.adjustment1.set_value(0)
        nmd.ui.adjustment1.set_lower(0)
        nmd.ui.adjustment1.set_upper(self.current['Object'].rows - 1)
        resp= nmd.run()
        if resp == Gtk.ResponseType.OK:
            try:
                M = self.M_G.read().extract_row(nmd.rows)
                d = _('Row no %i of matrix %s')% (nmd.rows, self.current['Name'])
                Obj = {'Object':M, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d}
                self.add_Object(Obj)
            except:
                msg = Gtk.MessageDialog(None, 0, 3, 0, _("That row doesn't exist"))
                msg.show()
        nmd.destroy()

    def on_tool_ext_col_activate(self, widget, data=None):
        nmd = NewmatrixDialog()
        nmd.modify_dialog(_('Column: '))
        nmd.ui.adjustment1.set_value(0)
        nmd.ui.adjustment1.set_lower(0)
        nmd.ui.adjustment1.set_upper(self.current['Object'].columns - 1)
        resp= nmd.run()
        if resp == Gtk.ResponseType.OK:
            try:
                M = self.M_G.read().extract_column(nmd.rows)
                d = _('Column no %i of matrix %s')% (nmd.rows, self.current['Name'])
                Obj = {'Object':M, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d}
                self.add_Object(Obj)
            except:
                msg = Gtk.MessageDialog(None, 0, 3, 0, _("That row doesn't exist"))
                msg.show()
        nmd.destroy()

    def on_tool_ext_el_activate(self, widget, data=None):
        if self.current['Type'] == 'Matrix':
            nmd = NewmatrixDialog()
            nmd.ui.adjustment1.set_value(0)
            nmd.ui.adjustment1.set_lower(0)
            nmd.ui.adjustment1.set_upper(self.current['Object'].rows - 1)
            nmd.ui.adjustment2.set_value(0)
            nmd.ui.adjustment2.set_lower(0)
            nmd.ui.adjustment2.set_upper(self.current['Object'].columns - 1)
            resp= nmd.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    M = self.M_G.read()[(nmd.rows, nmd.cols)]
                    d = _('Element (%i , %i) of matrix %s')%(nmd.rows, nmd.cols, self.current['Name'])
                    Obj = {'Object':M, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("That element doesn't exist"))
                    msg.show()
            nmd.destroy()
        elif self.current['Type'] == 'Vector':
            nmd = NewmatrixDialog()
            nmd.ui.adjustment1.set_value(0)
            nmd.ui.adjustment1.set_lower(0)
            nmd.ui.adjustment1.set_upper(self.current['Object'].dimension - 1)
            nmd.modify_dialog(_('Element: '))
            resp= nmd.run()
            if resp == Gtk.ResponseType.OK:
                try:
                    M = self.M_G.read()[nmd.rows]
                    d = _('Element %i of vector %s')% (nmd.rows, self.current['Name']) 
                    Obj = {'Object':M, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d}
                    self.add_Object(Obj)
                except:
                    msg = Gtk.MessageDialog(None, 0, 3, 0, _("That element doesn't exist"))
                    msg.show()
            nmd.destroy()

    def on_tool_conv_col_activate(self, widget, data=None):
        M = self.M_G.read().convert2cmatrix()
        d = _('Column matrix from vector ') + self.current['Name']
        Obj = {'Object':M, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
        self.add_Object(Obj)

    def on_tool_conv_row_activate(self, widget, data=None):
        M = self.M_G.read().convert2rmatrix()
        d = _('Column matrix from vector ') + self.current['Name']
        Obj = {'Object':M, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
        self.add_Object(Obj)

    def on_tool_conv_mat_activate(self, widget, data=None):
        M = Matrix(1, 1)
        M[(0, 0)] = self.M_G.read()
        d = _('Element matrix from scalar ') + self.current['Name']
        Obj = {'Object':M, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d}
        self.add_Object(Obj)

    def on_tool_conv_vect_activate(self, widget, data=None):
        v = Vect(1)
        v[0] = self.M_G.read()
        d = _('Element vector from scalar ') + self.current['Name']
        Obj = {'Object':v, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d}
        self.add_Object(Obj)

    def on_mnu_login_activate(self, widget, data=None):
        ubone = u1()
        ubone.login()

    def on_mnu_logout_activate(self, widget, data=None):
        ubone = u1()
        ubone.logout()

    def on_mnu_upload_activate(self, widget, data=None):
        ubone = u1()
        ubone.create_volume('alg3py')
        dial = Gtk.Dialog(_('Uploading files'), self, 0, (Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_OK, Gtk.ResponseType.OK))
        label = Gtk.Label()
        label.set_text(_("""You have to save the file before uploading it to Ubuntu One
Do you agree?"""))
        label.show()
        dial.get_content_area().add(label)
        resp = dial.run()
        if resp == Gtk.ResponseType.OK:
            self.save_file()
            ubone.upload(self.current['Path'], self.current['Name'])
        dial.destroy()

    def on_mnu_download_activate(self, widget, data=None):
        ubone = u1()
        files = ubone.get_children('alg3py')
        combo = Gtk.ComboBoxText()
        for f in files:
            combo.append_text(f)
        combo.show()
        dial = Gtk.Dialog(_('Downloading files'), self, 0, (Gtk.STOCK_CANCEL, Gtk.ResponseType.CANCEL, Gtk.STOCK_OK, Gtk.ResponseType.OK))
        dial.get_content_area().add(combo)
        resp = dial.run()
        if resp == Gtk.ResponseType.OK:
            temp = ubone.get('alg3py/' + combo.get_active_text())
            M = load_Mat(temp)
            if isinstance(M, Matrix):
                d = _('Matrix downloaded from UbuntuOne')
                Obj = {'Object':M, 'id':self.idc, 'Name':combo.get_active_text(), 'Type':'Matrix', 'Path':'-', 'using':True, 'descr':d }
            elif isinstance(M, Vect):
                d = _('Vector downloaded from UbuntuOne')
                Obj = {'Object':M, 'id':self.idc, 'Name':combo.get_active_text(), 'Type':'Vector', 'Path':'-', 'using':True, 'descr':d }
            else:
                d = _('Scalar downloaded from UbuntuOne')
                Obj = {'Object':M, 'id':self.idc, 'Name':combo.get_active_text(), 'Type':'Scalar', 'Path':'-', 'using':True, 'descr':d }
            self.add_Object(Obj)
            os.remove(temp)
        dial.destroy()

    def on_recentchoosermenu1_item_activated (self, widget, data=None):
        select = self.ui.recentchoosermenu1.get_current_item()
        filename = urlparse.urlparse(select.get_uri()).path
        M = load_Mat(filename)
        if isinstance(M, Matrix):
            d = _('Matrix opened from ') + filename
            Obj = {'Object':M, 'id':self.idc, 'Name':'A'+str(self.idc), 'Type':'Matrix', 'Path':filename, 'using':True, 'descr':d }
        elif isinstance(M, Vect):
            d = _('Vector opened from ') + filename
            Obj = {'Object':M, 'id':self.idc, 'Name':'v'+str(self.idc), 'Type':'Vector', 'Path':filename, 'using':True, 'descr':d }
        else:
            d = _('Scalar opened from ') + filename
            Obj = {'Object':M, 'id':self.idc, 'Name':'z'+str(self.idc), 'Type':'Scalar', 'Path':filename, 'using':True, 'descr':d }
        self.add_Object(Obj)
